/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.consumer.inercept;

import java.util.Collection;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionCreateContext;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionPreBuildIntercept;

@Activate(value={"header"}, order=2)
public class RequestHeaderIntercept
implements HttpConnectionPreBuildIntercept {
    @Override
    public void intercept(HttpConnectionCreateContext connectionCreateContext) {
        RestMethodMetadata restMethodMetadata = connectionCreateContext.getRestMethodMetadata();
        RequestTemplate requestTemplate = connectionCreateContext.getRequestTemplate();
        Set consumes = restMethodMetadata.getRequest().getConsumes();
        requestTemplate.addHeaders(RestHeaderEnum.CONTENT_TYPE.getHeader(), (Collection)consumes);
        Set produces = restMethodMetadata.getRequest().getProduces();
        if (produces == null || produces.isEmpty()) {
            requestTemplate.addHeader(RestHeaderEnum.ACCEPT.getHeader(), "*/*");
        } else {
            requestTemplate.addHeader(RestHeaderEnum.ACCEPT.getHeader(), (Object)produces);
        }
    }
}

