/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.handler;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.rest.PathAndInvokerMapper;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.RestRPCInvocationUtil;
import org.apache.dubbo.rpc.protocol.rest.exception.MediaTypeUnSupportException;
import org.apache.dubbo.rpc.protocol.rest.exception.ParamParseException;
import org.apache.dubbo.rpc.protocol.rest.exception.PathNoFoundException;
import org.apache.dubbo.rpc.protocol.rest.exception.UnSupportContentTypeException;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionMapper;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodecManager;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;
import org.apache.dubbo.rpc.protocol.rest.pair.InvokerAndRestMethodMetadataPair;
import org.apache.dubbo.rpc.protocol.rest.pair.MessageCodecResultPair;
import org.apache.dubbo.rpc.protocol.rest.request.NettyRequestFacade;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;
import org.apache.dubbo.rpc.protocol.rest.util.MediaTypeUtil;

public class NettyHttpHandler
implements HttpHandler<NettyRequestFacade, NettyHttpResponse> {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final PathAndInvokerMapper pathAndInvokerMapper;
    private final ExceptionMapper exceptionMapper;

    public NettyHttpHandler(PathAndInvokerMapper pathAndInvokerMapper, ExceptionMapper exceptionMapper) {
        this.pathAndInvokerMapper = pathAndInvokerMapper;
        this.exceptionMapper = exceptionMapper;
    }

    public void handle(NettyRequestFacade requestFacade, NettyHttpResponse nettyHttpResponse) throws IOException {
        RpcContext.getServiceContext().setRemoteAddress(requestFacade.getRemoteAddr(), requestFacade.getRemotePort());
        RpcContext.getServiceContext().setLocalAddress(requestFacade.getLocalAddr(), requestFacade.getLocalPort());
        RpcContext.getServiceContext().setRequest((Object)requestFacade);
        RpcContext.getServiceContext().setResponse((Object)nettyHttpResponse);
        RpcContext.getServerAttachment().setObjectAttachment("pathAndInvokerMapper", (Object)this.pathAndInvokerMapper);
        FullHttpRequest nettyHttpRequest = (FullHttpRequest)requestFacade.getRequest();
        try {
            this.doHandler((HttpRequest)nettyHttpRequest, nettyHttpResponse, requestFacade);
        }
        catch (PathNoFoundException pathNoFoundException) {
            this.logger.error("", pathNoFoundException.getMessage(), "", "dubbo rest protocol provider path   no found ,raw request is :" + nettyHttpRequest, (Throwable)pathNoFoundException);
            nettyHttpResponse.sendError(404, pathNoFoundException.getMessage());
        }
        catch (ParamParseException paramParseException) {
            this.logger.error("", paramParseException.getMessage(), "", "dubbo rest protocol provider param parse error ,and raw request is :" + nettyHttpRequest, (Throwable)paramParseException);
            nettyHttpResponse.sendError(400, paramParseException.getMessage());
        }
        catch (MediaTypeUnSupportException contentTypeException) {
            this.logger.error("", contentTypeException.getMessage(), "", "dubbo rest protocol provider content-type un support" + nettyHttpRequest, (Throwable)contentTypeException);
            nettyHttpResponse.sendError(415, contentTypeException.getMessage());
        }
        catch (Throwable throwable) {
            this.logger.error("", throwable.getMessage(), "", "dubbo rest protocol provider error ,and raw request is  " + nettyHttpRequest, throwable);
            nettyHttpResponse.sendError(500, "dubbo rest invoke Internal error, message is " + throwable.getMessage() + " , stacktrace is: " + NettyHttpHandler.stackTraceToString(throwable));
        }
    }

    protected void doHandler(HttpRequest nettyHttpRequest, NettyHttpResponse nettyHttpResponse, RequestFacade request) throws Exception {
        InvokerAndRestMethodMetadataPair restMethodMetadataPair = RestRPCInvocationUtil.getRestMethodMetadataAndInvokerPair(request);
        if (restMethodMetadataPair == null) {
            throw new PathNoFoundException("rest service Path no found, current path info:" + RestRPCInvocationUtil.createPathMatcher(request));
        }
        Invoker invoker = restMethodMetadataPair.getInvoker();
        RestMethodMetadata restMethodMetadata = restMethodMetadataPair.getRestMethodMetadata();
        if (!restMethodMetadata.getRequest().methodAllowed(request.getMethod())) {
            nettyHttpResponse.sendError(405, "service require request method is : " + restMethodMetadata.getRequest().getMethod() + ", but current request method is: " + request.getMethod());
            return;
        }
        this.acceptSupportJudge(request, restMethodMetadata.getReflectMethod().getReturnType());
        RpcInvocation rpcInvocation = RestRPCInvocationUtil.createBaseRpcInvocation(request, restMethodMetadata);
        RestRPCInvocationUtil.parseMethodArgs(rpcInvocation, request, nettyHttpRequest, nettyHttpResponse, restMethodMetadata);
        Result result = invoker.invoke((Invocation)rpcInvocation);
        if (result.hasException()) {
            Throwable exception = result.getException();
            this.logger.error("", exception.getMessage(), "", "dubbo rest protocol provider Invoker invoke error", exception);
            if (this.exceptionMapper.hasExceptionMapper(exception)) {
                this.writeResult(nettyHttpResponse, request, invoker, this.exceptionMapper.exceptionToResult(result.getException()), rpcInvocation.getReturnType());
                nettyHttpResponse.setStatus(200);
            } else {
                nettyHttpResponse.sendError(500, "\n dubbo rest business exception, error cause is: " + result.getException().getCause() + "\n message is: " + result.getException().getMessage() + "\n stacktrace is: " + NettyHttpHandler.stackTraceToString(exception));
            }
        } else {
            Object value = result.getValue();
            this.writeResult(nettyHttpResponse, request, invoker, value, rpcInvocation.getReturnType());
            nettyHttpResponse.setStatus(200);
        }
    }

    private void writeResult(NettyHttpResponse nettyHttpResponse, RequestFacade request, Invoker invoker, Object value, Class returnType) throws Exception {
        MediaType mediaType = this.getAcceptMediaType(request, returnType);
        MessageCodecResultPair booleanMediaTypePair = HttpMessageCodecManager.httpMessageEncode(nettyHttpResponse.getOutputStream(), value, invoker.getUrl(), mediaType, returnType);
        nettyHttpResponse.addOutputHeaders(RestHeaderEnum.CONTENT_TYPE.getHeader(), booleanMediaTypePair.getMediaType().value);
    }

    private MediaType getAcceptMediaType(RequestFacade request, Class<?> returnType) {
        String accept = request.getHeader(RestHeaderEnum.ACCEPT.getHeader());
        MediaType mediaType = MediaTypeUtil.convertMediaType(returnType, accept);
        return mediaType;
    }

    private void acceptSupportJudge(RequestFacade requestFacade, Class<?> returnType) {
        block3: {
            try {
                this.getAcceptMediaType(requestFacade, returnType);
            }
            catch (UnSupportContentTypeException e) {
                MediaType mediaType = HttpMessageCodecManager.typeSupport(returnType);
                String accept = requestFacade.getHeader(RestHeaderEnum.ACCEPT.getHeader());
                if (mediaType == null || accept == null) {
                    throw e;
                }
                if (accept.contains(mediaType.value)) break block3;
                throw e;
            }
        }
    }

    public static String stackTraceToString(Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        StringBuilder stringBuilder = new StringBuilder("\n");
        for (StackTraceElement traceElement : stackTrace) {
            stringBuilder.append("\tat " + traceElement).append("\n");
        }
        return stringBuilder.toString();
    }
}

