/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.extension.resteasy.filter;

import java.util.List;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.extension.resteasy.ResteasyContext;
import org.apache.dubbo.rpc.protocol.rest.extension.resteasy.filter.DubboPreMatchContainerRequestContext;
import org.apache.dubbo.rpc.protocol.rest.filter.RestRequestFilter;
import org.apache.dubbo.rpc.protocol.rest.filter.context.RestFilterContext;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;
import org.jboss.resteasy.specimpl.BuiltResponse;

@Activate(value={"resteasy"}, onClass={"javax.ws.rs.container.ContainerRequestFilter", "org.jboss.resteasy.plugins.server.netty.NettyHttpRequest", "org.jboss.resteasy.plugins.server.netty.NettyHttpResponse"}, order=0x7FFFFFFE)
public class ResteasyRequestContainerFilterAdapter
implements RestRequestFilter,
ResteasyContext {
    @Override
    public void filter(RestFilterContext restFilterContext) throws Exception {
        ServiceDeployer serviceDeployer = restFilterContext.getServiceDeployer();
        RequestFacade requestFacade = restFilterContext.getRequestFacade();
        URL url = restFilterContext.getUrl();
        NettyHttpResponse response = restFilterContext.getResponse();
        List<ContainerRequestFilter> containerRequestFilters = this.getExtension(serviceDeployer, ContainerRequestFilter.class);
        if (containerRequestFilters.isEmpty()) {
            return;
        }
        DubboPreMatchContainerRequestContext containerRequestContext = this.convertHttpRequestToContainerRequestContext(requestFacade, containerRequestFilters.toArray(new ContainerRequestFilter[0]));
        RpcContext.getServiceContext().setObjectAttachment("resteasyNettyHttpRequest", (Object)containerRequestContext.getHttpRequest());
        try {
            BuiltResponse restResponse = containerRequestContext.filter();
            if (restResponse == null) {
                return;
            }
            this.addResponseHeaders(response, (MultivaluedMap<String, Object>)restResponse.getHeaders());
            this.writeResteasyResponse(url, requestFacade, response, restResponse);
            restFilterContext.setComplete(true);
        }
        catch (Throwable e) {
            throw new RuntimeException("dubbo rest resteasy ContainerRequestFilter write response encode error", e);
        }
    }
}

