/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.exception.MediaTypeUnSupportException;
import org.apache.dubbo.rpc.protocol.rest.exception.ParamParseException;
import org.apache.dubbo.rpc.protocol.rest.exception.PathNoFoundException;
import org.apache.dubbo.rpc.protocol.rest.filter.RestFilter;
import org.apache.dubbo.rpc.protocol.rest.filter.RestRequestFilter;
import org.apache.dubbo.rpc.protocol.rest.filter.RestResponseFilter;
import org.apache.dubbo.rpc.protocol.rest.filter.ServiceInvokeRestFilter;
import org.apache.dubbo.rpc.protocol.rest.filter.context.RestFilterContext;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;
import org.apache.dubbo.rpc.protocol.rest.request.NettyRequestFacade;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;

public class NettyHttpHandler
implements HttpHandler<NettyRequestFacade, NettyHttpResponse> {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final ServiceDeployer serviceDeployer;
    private final URL url;
    private final List<RestFilter> restRequestFilters;
    private final List<RestFilter> restResponseFilters;

    public NettyHttpHandler(ServiceDeployer serviceDeployer, URL url) {
        this.serviceDeployer = serviceDeployer;
        this.url = url;
        this.restRequestFilters = new ArrayList<RestFilter>(url.getOrDefaultFrameworkModel().getExtensionLoader(RestRequestFilter.class).getActivateExtensions());
        this.restResponseFilters = new ArrayList<RestFilter>(url.getOrDefaultFrameworkModel().getExtensionLoader(RestResponseFilter.class).getActivateExtensions());
    }

    public void handle(NettyRequestFacade requestFacade, NettyHttpResponse nettyHttpResponse) throws IOException {
        RpcContext.getServiceContext().setRemoteAddress(requestFacade.getRemoteAddr(), requestFacade.getRemotePort());
        RpcContext.getServiceContext().setLocalAddress(requestFacade.getLocalAddr(), requestFacade.getLocalPort());
        RpcContext.getServiceContext().setRequest((Object)requestFacade);
        RpcContext.getServiceContext().setResponse((Object)nettyHttpResponse);
        Object nettyHttpRequest = requestFacade.getRequest();
        RpcContext.getServiceContext().setObjectAttachment("serviceDeployer", (Object)this.serviceDeployer);
        try {
            this.executeFilters(this.url, requestFacade, nettyHttpResponse, this.serviceDeployer, this.restRequestFilters);
        }
        catch (PathNoFoundException pathNoFoundException) {
            this.logger.error("", pathNoFoundException.getMessage(), "", "dubbo rest protocol provider path   no found ,raw request is :" + nettyHttpRequest, (Throwable)pathNoFoundException);
            nettyHttpResponse.sendError(404, pathNoFoundException.getMessage());
        }
        catch (ParamParseException paramParseException) {
            this.logger.error("", paramParseException.getMessage(), "", "dubbo rest protocol provider param parse error ,and raw request is :" + nettyHttpRequest, (Throwable)paramParseException);
            nettyHttpResponse.sendError(400, paramParseException.getMessage());
        }
        catch (MediaTypeUnSupportException contentTypeException) {
            this.logger.error("", contentTypeException.getMessage(), "", "dubbo rest protocol provider content-type un support" + nettyHttpRequest, (Throwable)contentTypeException);
            nettyHttpResponse.sendError(415, contentTypeException.getMessage());
        }
        catch (Throwable throwable) {
            this.logger.error("", throwable.getMessage(), "", "dubbo rest protocol provider error ,and raw request is  " + nettyHttpRequest, throwable);
            nettyHttpResponse.sendError(500, "dubbo rest invoke Internal error, message is " + throwable.getMessage() + " ,and exception type is : " + throwable.getClass() + " , stacktrace is: " + ServiceInvokeRestFilter.stackTraceToString(throwable));
        }
        try {
            this.executeFilters(this.url, requestFacade, nettyHttpResponse, this.serviceDeployer, this.restResponseFilters);
        }
        catch (Throwable throwable) {
            this.logger.error("", throwable.getMessage(), "", "dubbo rest protocol provider error ,and raw request is  " + nettyHttpRequest, throwable);
            nettyHttpResponse.sendError(500, "dubbo rest invoke Internal error, message is " + throwable.getMessage() + " ,and exception type is : " + throwable.getClass() + " , stacktrace is: " + ServiceInvokeRestFilter.stackTraceToString(throwable));
        }
    }

    public void executeFilters(URL url, RequestFacade requestFacade, NettyHttpResponse nettyHttpResponse, ServiceDeployer serviceDeployer, List<RestFilter> restFilters) throws Exception {
        RestFilterContext restFilterContext = new RestFilterContext(url, requestFacade, nettyHttpResponse, serviceDeployer);
        for (RestFilter restResponseFilter : restFilters) {
            restResponseFilter.filter(restFilterContext);
            if (!restFilterContext.complete()) continue;
            break;
        }
    }
}

