/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.extension.resteasy.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.interception.ResponseContainerRequestContext;
import org.jboss.resteasy.core.interception.jaxrs.SuspendableContainerResponseContext;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class DubboContainerResponseContextImpl
implements SuspendableContainerResponseContext {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DubboContainerResponseContextImpl.class);
    protected final HttpRequest request;
    protected final HttpResponse httpResponse;
    protected final BuiltResponse jaxrsResponse;
    private ResponseContainerRequestContext requestContext;
    private ContainerResponseFilter[] responseFilters;
    private ServerResponseWriter.RunnableWithIOException continuation;
    private int currentFilter;
    private boolean suspended;
    private boolean filterReturnIsMeaningful = true;
    private Map<Class<?>, Object> contextDataMap;
    private boolean inFilter;
    private Throwable throwable;
    private Consumer<Throwable> onComplete;
    private boolean weSuspended;

    public DubboContainerResponseContextImpl(HttpRequest request, HttpResponse httpResponse, BuiltResponse serverResponse, ResponseContainerRequestContext requestContext, ContainerResponseFilter[] responseFilters, Consumer<Throwable> onComplete, ServerResponseWriter.RunnableWithIOException continuation) {
        this.request = request;
        this.httpResponse = httpResponse;
        this.jaxrsResponse = serverResponse;
        this.requestContext = requestContext;
        this.responseFilters = responseFilters;
        this.continuation = continuation;
        this.onComplete = onComplete;
        this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
    }

    public BuiltResponse getJaxrsResponse() {
        return this.jaxrsResponse;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getStatus() {
        return this.jaxrsResponse.getStatus();
    }

    public void setStatus(int code) {
        this.httpResponse.setStatus(code);
        this.jaxrsResponse.setStatus(code);
    }

    public Response.StatusType getStatusInfo() {
        return this.jaxrsResponse.getStatusInfo();
    }

    public void setStatusInfo(Response.StatusType statusInfo) {
        this.httpResponse.setStatus(statusInfo.getStatusCode());
        this.jaxrsResponse.setStatus(statusInfo.getStatusCode());
    }

    public Class<?> getEntityClass() {
        return this.jaxrsResponse.getEntityClass();
    }

    public Type getEntityType() {
        return this.jaxrsResponse.getGenericType();
    }

    public void setEntity(Object entity) {
        if (entity != null && this.jaxrsResponse.getEntity() != null) {
            logger.info("Dubbo container response context filter set entity ,before entity is: " + this.jaxrsResponse.getEntity() + "and after entity is: " + entity);
        }
        this.jaxrsResponse.setEntity(entity);
        this.getHeaders().remove((Object)"Content-Length");
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        if (entity != null && this.jaxrsResponse.getEntity() != null) {
            logger.info("Dubbo container response context filter set entity ,before entity is: " + this.jaxrsResponse.getEntity() + "and after entity is: " + entity);
        }
        this.jaxrsResponse.setEntity(entity);
        this.jaxrsResponse.setAnnotations(annotations);
        this.jaxrsResponse.getHeaders().putSingle((Object)"Content-Type", (Object)mediaType);
        this.getHeaders().remove((Object)"Content-Length");
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.jaxrsResponse.getMetadata();
    }

    public Set<String> getAllowedMethods() {
        return this.jaxrsResponse.getAllowedMethods();
    }

    public Date getDate() {
        return this.jaxrsResponse.getDate();
    }

    public Locale getLanguage() {
        return this.jaxrsResponse.getLanguage();
    }

    public int getLength() {
        return this.jaxrsResponse.getLength();
    }

    public MediaType getMediaType() {
        return this.jaxrsResponse.getMediaType();
    }

    public Map<String, NewCookie> getCookies() {
        return this.jaxrsResponse.getCookies();
    }

    public EntityTag getEntityTag() {
        return this.jaxrsResponse.getEntityTag();
    }

    public Date getLastModified() {
        return this.jaxrsResponse.getLastModified();
    }

    public URI getLocation() {
        return this.jaxrsResponse.getLocation();
    }

    public Set<Link> getLinks() {
        return this.jaxrsResponse.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.jaxrsResponse.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.jaxrsResponse.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        return this.jaxrsResponse.getLinkBuilder(relation);
    }

    public boolean hasEntity() {
        return !this.jaxrsResponse.isClosed() && this.jaxrsResponse.hasEntity();
    }

    public Object getEntity() {
        return !this.jaxrsResponse.isClosed() ? this.jaxrsResponse.getEntity() : null;
    }

    public OutputStream getEntityStream() {
        try {
            return this.httpResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setEntityStream(OutputStream entityStream) {
        this.httpResponse.setOutputStream(entityStream);
    }

    public Annotation[] getEntityAnnotations() {
        return this.jaxrsResponse.getAnnotations();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.jaxrsResponse.getStringHeaders();
    }

    public String getHeaderString(String name) {
        return this.jaxrsResponse.getHeaderString(name);
    }

    public synchronized void suspend() {
        if (this.continuation == null) {
            throw new RuntimeException("Suspend not supported yet");
        }
        this.suspended = true;
    }

    public synchronized void resume() {
        if (!this.suspended) {
            throw new RuntimeException("Cannot resume: not suspended");
        }
        if (this.inFilter) {
            this.suspended = false;
            return;
        }
        try (ResteasyProviderFactory.CloseableContext c = ResteasyProviderFactory.addCloseableContextDataLevel(this.contextDataMap);){
            this.filter();
        }
        catch (Throwable t) {
            this.writeException(t);
        }
    }

    public synchronized void resume(Throwable t) {
        if (!this.suspended) {
            throw new RuntimeException("Cannot resume: not suspended");
        }
        if (this.inFilter) {
            this.throwable = t;
            this.suspended = false;
        } else {
            try (ResteasyProviderFactory.CloseableContext c = ResteasyProviderFactory.addCloseableContextDataLevel(this.contextDataMap);){
                this.writeException(t);
            }
        }
    }

    private void writeException(Throwable t) {
        HttpResponse httpResponse = (HttpResponse)this.contextDataMap.get(HttpResponse.class);
        SynchronousDispatcher dispatcher = (SynchronousDispatcher)this.contextDataMap.get(Dispatcher.class);
        ResteasyAsynchronousResponse asyncResponse = this.request.getAsyncContext().getAsyncResponse();
        dispatcher.unhandledAsynchronousException(httpResponse, t);
        this.onComplete.accept(t);
        asyncResponse.complete();
        asyncResponse.completionCallbacks(t);
    }

    public synchronized void filter() throws IOException {
        while (this.currentFilter < this.responseFilters.length) {
            ContainerResponseFilter filter = this.responseFilters[this.currentFilter++];
            try {
                this.suspended = false;
                this.throwable = null;
                this.inFilter = true;
                filter.filter((ContainerRequestContext)this.requestContext, (ContainerResponseContext)this);
            }
            catch (IOException e) {
                throw new ApplicationException((Throwable)e);
            }
            finally {
                this.inFilter = false;
            }
            if (this.suspended) {
                if (!this.request.getAsyncContext().isSuspended()) {
                    this.request.getAsyncContext().suspend();
                    this.weSuspended = true;
                }
                this.filterReturnIsMeaningful = false;
                return;
            }
            if (this.throwable == null) continue;
            if (this.filterReturnIsMeaningful) {
                SynchronousDispatcher.rethrow((Throwable)this.throwable);
                continue;
            }
            this.writeException(this.throwable);
            return;
        }
        if (this.continuation == null) {
            return;
        }
        if (this.filterReturnIsMeaningful) {
            this.continuation.run();
            this.onComplete.accept(null);
            return;
        }
        try {
            this.continuation.run();
            this.onComplete.accept(null);
            if (this.weSuspended) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)this.contextDataMap.get(HttpServletRequest.class);
                httpServletRequest.getAsyncContext().complete();
            }
        }
        catch (IOException e) {
            logger.error("", "Dubbo container response context filter error", "request method is: " + this.request.getHttpMethod() + "and request uri is:" + this.request.getUri().getPath(), "", (Throwable)e);
        }
    }
}

