/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.metadata.rest.PathMatcher;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.annotation.ParamParserManager;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider.ProviderParseContext;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.exception.ParamParseException;
import org.apache.dubbo.rpc.protocol.rest.pair.InvokerAndRestMethodMetadataPair;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;
import org.apache.dubbo.rpc.protocol.rest.util.HttpHeaderUtil;

public class RestRPCInvocationUtil {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RestRPCInvocationUtil.class);

    public static void parseMethodArgs(RpcInvocation rpcInvocation, RequestFacade request, Object servletRequest, Object servletResponse, RestMethodMetadata restMethodMetadata) {
        try {
            ProviderParseContext parseContext = RestRPCInvocationUtil.createParseContext(request, servletRequest, servletResponse, restMethodMetadata);
            Object[] args = ParamParserManager.providerParamParse(parseContext);
            List<ArgInfo> argInfos = parseContext.getArgInfos();
            for (ArgInfo argInfo : argInfos) {
                if (!argInfo.getParamType().isPrimitive() || args[argInfo.getIndex()] != null) continue;
                throw new ParamParseException("\n dubbo provider primitive arg not exist in request, method is: " + restMethodMetadata.getReflectMethod() + "\n type is: " + argInfo.getParamType() + " \n and arg index is: " + argInfo.getIndex());
            }
            rpcInvocation.setArguments(args);
        }
        catch (Exception e) {
            logger.error("", e.getMessage(), "", "dubbo rest provider method args parse error: ", (Throwable)e);
            throw new ParamParseException(e.getMessage());
        }
    }

    private static ProviderParseContext createParseContext(RequestFacade request, Object originRequest, Object originResponse, RestMethodMetadata restMethodMetadata) {
        ProviderParseContext parseContext = new ProviderParseContext(request);
        parseContext.setResponse(originResponse);
        parseContext.setRequest(originRequest);
        Object[] objects = new Object[restMethodMetadata.getArgInfos().size()];
        parseContext.setArgs(Arrays.asList(objects));
        parseContext.setArgInfos(restMethodMetadata.getArgInfos());
        return parseContext;
    }

    public static RpcInvocation createBaseRpcInvocation(RequestFacade request, RestMethodMetadata restMethodMetadata) {
        RpcInvocation rpcInvocation = new RpcInvocation();
        rpcInvocation.setParameterTypes((Class[])restMethodMetadata.getReflectMethod().getParameterTypes());
        rpcInvocation.setReturnType(restMethodMetadata.getReflectMethod().getReturnType());
        rpcInvocation.setMethodName(restMethodMetadata.getMethod().getName());
        HttpHeaderUtil.parseRequest(rpcInvocation, request);
        String serviceKey = BaseServiceMetadata.buildServiceKey((String)request.getHeader(RestHeaderEnum.PATH.getHeader()), (String)request.getHeader(RestHeaderEnum.GROUP.getHeader()), (String)request.getHeader(RestHeaderEnum.VERSION.getHeader()));
        rpcInvocation.setTargetServiceUniqueName(serviceKey);
        return rpcInvocation;
    }

    public static InvokerAndRestMethodMetadataPair getRestMethodMetadataAndInvokerPair(PathMatcher pathMatcher, ServiceDeployer serviceDeployer) {
        return serviceDeployer.getPathAndInvokerMapper().getRestMethodMetadata(pathMatcher);
    }

    public static InvokerAndRestMethodMetadataPair getRestMethodMetadataAndInvokerPair(RequestFacade request) {
        PathMatcher pathMather = RestRPCInvocationUtil.createPathMatcher(request);
        return RestRPCInvocationUtil.getRestMethodMetadataAndInvokerPair(pathMather, request.getServiceDeployer());
    }

    public static Invoker getInvokerByRequest(RequestFacade request) {
        PathMatcher pathMatcher = RestRPCInvocationUtil.createPathMatcher(request);
        return RestRPCInvocationUtil.getInvoker(pathMatcher, request.getServiceDeployer());
    }

    public static Invoker getInvokerByServiceInvokeMethod(Method serviceMethod, ServiceDeployer serviceDeployer) {
        if (serviceMethod == null) {
            return null;
        }
        PathMatcher pathMatcher = PathMatcher.getInvokeCreatePathMatcher((Method)serviceMethod);
        InvokerAndRestMethodMetadataPair pair = RestRPCInvocationUtil.getRestMethodMetadataAndInvokerPair(pathMatcher, serviceDeployer);
        if (pair == null) {
            return null;
        }
        return pair.getInvoker();
    }

    public static Invoker getInvoker(PathMatcher pathMatcher, ServiceDeployer serviceDeployer) {
        InvokerAndRestMethodMetadataPair pair = RestRPCInvocationUtil.getRestMethodMetadataAndInvokerPair(pathMatcher, serviceDeployer);
        if (pair == null) {
            return null;
        }
        return pair.getInvoker();
    }

    public static PathMatcher createPathMatcher(RequestFacade request) {
        String path = request.getPath();
        String version = request.getHeader(RestHeaderEnum.VERSION.getHeader());
        String group = request.getHeader(RestHeaderEnum.GROUP.getHeader());
        String method = request.getMethod();
        return PathMatcher.getInvokeCreatePathMatcher((String)path, (String)version, (String)group, null, (String)method);
    }
}

