/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.extension.resteasy.intercept;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.commons.io.IOUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.extension.resteasy.ResteasyContext;
import org.apache.dubbo.rpc.protocol.rest.extension.resteasy.intercept.DubboServerWriterInterceptorContext;
import org.apache.dubbo.rpc.protocol.rest.filter.RestResponseInterceptor;
import org.apache.dubbo.rpc.protocol.rest.filter.context.RestInterceptContext;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;
import org.jboss.resteasy.core.interception.AbstractWriterInterceptorContext;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Activate(value={"resteasy"}, onClass={"javax.ws.rs.ext.WriterInterceptorContext", "org.jboss.resteasy.plugins.server.netty.NettyHttpRequest", "org.jboss.resteasy.plugins.server.netty.NettyHttpResponse"})
public class ResteasyWriterInterceptorAdapter
implements RestResponseInterceptor,
ResteasyContext {
    private ResteasyProviderFactory resteasyProviderFactory = this.getResteasyProviderFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(RestInterceptContext restResponseInterceptor) throws Exception {
        RpcInvocation rpcInvocation = restResponseInterceptor.getRpcInvocation();
        ServiceDeployer serviceDeployer = restResponseInterceptor.getServiceDeployer();
        RequestFacade request = restResponseInterceptor.getRequestFacade();
        NettyHttpResponse response = restResponseInterceptor.getResponse();
        Object result = restResponseInterceptor.getResult();
        Class type = rpcInvocation.getReturnType();
        List<WriterInterceptor> extension = serviceDeployer.getExtensions(WriterInterceptor.class);
        if (extension.isEmpty()) {
            return;
        }
        NettyHttpRequest nettyHttpRequest = (NettyHttpRequest)restResponseInterceptor.getOriginRequest();
        NettyHttpRequest restRequest = nettyHttpRequest == null ? this.createNettyHttpRequest(request) : nettyHttpRequest;
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            String value = this.getAcceptMediaType((RequestFacade)request, type).value;
            MediaType mediaType = MediaType.valueOf((String)value);
            AbstractWriterInterceptorContext writerContext = this.getAbstractWriterInterceptorContext((HttpRequest)restRequest, extension, result, type, type, mediaType, os, (MultivaluedMap<String, Object>)headers);
            writerContext.proceed();
            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)writerContext.getOutputStream();
            this.addResponseHeaders(response, (MultivaluedMap<String, Object>)writerContext.getHeaders());
            if (outputStream.size() <= 0) {
                return;
            }
            this.restOutputStream(response);
            byte[] bytes = outputStream.toByteArray();
            response.getOutputStream().write(bytes);
            response.addOutputHeaders(RestHeaderEnum.CONTENT_TYPE.getHeader(), value);
            restResponseInterceptor.setComplete(true);
        }
        finally {
            IOUtils.close((Closeable)os);
        }
    }

    private AbstractWriterInterceptorContext getAbstractWriterInterceptorContext(HttpRequest request, List<WriterInterceptor> extension, Object entity, Class type, Type genericType, MediaType mediaType, ByteArrayOutputStream os, MultivaluedMap<String, Object> headers) {
        DubboServerWriterInterceptorContext writerContext = new DubboServerWriterInterceptorContext(extension.toArray(new WriterInterceptor[0]), this.resteasyProviderFactory, entity, type, genericType, new Annotation[0], mediaType, headers, os, request);
        return writerContext;
    }

    protected ResteasyProviderFactory getResteasyProviderFactory() {
        return new ResteasyProviderFactory();
    }
}

