/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.netty;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.netty.ChunkOutputStream;
import org.apache.dubbo.rpc.protocol.rest.netty.HttpResponse;

public class NettyHttpResponse
implements HttpResponse {
    private static final int EMPTY_CONTENT_LENGTH = 0;
    private int status = 200;
    private OutputStream os;
    private Map<String, List<String>> outputHeaders = new HashMap<String, List<String>>();
    private final ChannelHandlerContext ctx;
    private boolean committed;
    private boolean keepAlive;
    private HttpMethod method;
    private Object responseBody;
    private Class<?> entityClass;

    public NettyHttpResponse(ChannelHandlerContext ctx, boolean keepAlive, URL url) {
        this(ctx, keepAlive, null, url);
    }

    public NettyHttpResponse(ChannelHandlerContext ctx, boolean keepAlive, HttpMethod method, URL url) {
        this.method = method;
        this.os = new ChunkOutputStream(this, ctx, url.getParameter("payload", 0x800000));
        this.ctx = ctx;
        this.keepAlive = keepAlive;
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        if (status > 200) {
            this.addOutputHeaders(RestHeaderEnum.CONTENT_TYPE.getHeader(), MediaType.TEXT_PLAIN.value);
        }
        this.status = status;
    }

    @Override
    public Map<String, List<String>> getOutputHeaders() {
        return this.outputHeaders;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    @Override
    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    @Override
    public void sendError(int status, String message) throws IOException {
        this.setStatus(status);
        this.setResponseBody(message);
        if (message != null) {
            this.getOutputStream().write(message.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public void reset() {
        if (this.committed) {
            throw new IllegalStateException("Messages.MESSAGES.alreadyCommitted()");
        }
        this.outputHeaders.clear();
        this.outputHeaders.clear();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public DefaultHttpResponse getDefaultHttpResponse() {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.getStatus()));
        this.transformResponseHeaders((io.netty.handler.codec.http.HttpResponse)res);
        return res;
    }

    public DefaultHttpResponse getEmptyHttpResponse() {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.getStatus()));
        if (this.method == null || !this.method.equals((Object)HttpMethod.HEAD)) {
            res.headers().add("Content-Length", (Object)0);
        }
        this.transformResponseHeaders((io.netty.handler.codec.http.HttpResponse)res);
        return res;
    }

    private void transformResponseHeaders(io.netty.handler.codec.http.HttpResponse res) {
        NettyHttpResponse.transformHeaders(this, res);
    }

    public void prepareChunkStream() {
        this.committed = true;
        DefaultHttpResponse response = this.getDefaultHttpResponse();
        HttpHeaders.setTransferEncodingChunked((HttpMessage)response);
        this.ctx.write((Object)response);
    }

    public void finish() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
        ChannelFuture future = this.isCommitted() ? this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT) : this.ctx.writeAndFlush((Object)this.getEmptyHttpResponse());
        if (!this.isKeepAlive()) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.getOutputStream().close();
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
        this.ctx.flush();
    }

    @Override
    public void addOutputHeaders(String name, String value) {
        List<String> values = this.outputHeaders.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.outputHeaders.put(name, values);
        }
        values.add(value);
    }

    public static void transformHeaders(NettyHttpResponse nettyResponse, io.netty.handler.codec.http.HttpResponse response) {
        for (Map.Entry<String, List<String>> entry : nettyResponse.getOutputHeaders().entrySet()) {
            String key = entry.getKey();
            for (String value : entry.getValue()) {
                response.headers().set(key, (Object)value);
            }
        }
    }

    public Object getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(Object responseBody) {
        this.responseBody = responseBody;
        if (responseBody != null) {
            this.entityClass = responseBody.getClass();
        }
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }
}

