/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.ParameterTypesComparator;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.remoting.http.RestClient;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.protocol.rest.ReferenceCountedClient;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionCreateContext;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionPreBuildIntercept;
import org.apache.dubbo.rpc.protocol.rest.exception.ParamParseException;
import org.apache.dubbo.rpc.protocol.rest.exception.PathNoFoundException;
import org.apache.dubbo.rpc.protocol.rest.exception.RemoteServerInternalException;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodecManager;
import org.apache.dubbo.rpc.protocol.rest.util.HttpHeaderUtil;
import org.apache.dubbo.rpc.protocol.rest.util.MediaTypeUtil;

public class RestInvoker<T>
extends AbstractInvoker<T> {
    private final ServiceRestMetadata serviceRestMetadata;
    private final ReferenceCountedClient<? extends RestClient> referenceCountedClient;
    private final Set<HttpConnectionPreBuildIntercept> httpConnectionPreBuildIntercepts;

    public RestInvoker(Class type, URL url, ReferenceCountedClient<? extends RestClient> referenceCountedClient, Set<HttpConnectionPreBuildIntercept> httpConnectionPreBuildIntercepts, ServiceRestMetadata serviceRestMetadata) {
        super(type, url);
        this.serviceRestMetadata = serviceRestMetadata;
        this.referenceCountedClient = referenceCountedClient;
        this.httpConnectionPreBuildIntercepts = httpConnectionPreBuildIntercepts;
    }

    protected Result doInvoke(Invocation invocation) {
        Map metadataMap = this.serviceRestMetadata.getMethodToServiceMap();
        RestMethodMetadata restMethodMetadata = (RestMethodMetadata)((Map)metadataMap.get(invocation.getMethodName())).get(ParameterTypesComparator.getInstance((Class[])invocation.getParameterTypes()));
        RequestTemplate requestTemplate = new RequestTemplate(invocation, restMethodMetadata.getRequest().getMethod(), this.getUrl().getAddress());
        HttpConnectionCreateContext httpConnectionCreateContext = this.createHttpConnectionCreateContext(invocation, this.serviceRestMetadata, restMethodMetadata, requestTemplate);
        for (HttpConnectionPreBuildIntercept intercept : this.httpConnectionPreBuildIntercepts) {
            intercept.intercept(httpConnectionCreateContext);
        }
        CompletableFuture future = this.referenceCountedClient.getClient().send(requestTemplate);
        CompletableFuture responseFuture = new CompletableFuture();
        AsyncRpcResult asyncRpcResult = new AsyncRpcResult(responseFuture, invocation);
        future.whenComplete((r, t) -> {
            if (t != null) {
                responseFuture.completeExceptionally((Throwable)t);
            } else {
                AppResponse appResponse = new AppResponse();
                try {
                    int responseCode = r.getResponseCode();
                    MediaType mediaType = MediaType.TEXT_PLAIN;
                    if (responseCode == 404) {
                        responseFuture.completeExceptionally(new PathNoFoundException(r.getMessage()));
                    } else if (400 <= responseCode && responseCode < 500) {
                        responseFuture.completeExceptionally(new ParamParseException(r.getMessage()));
                    } else if (responseCode >= 500) {
                        responseFuture.completeExceptionally(new RemoteServerInternalException(r.getMessage()));
                    } else if (responseCode < 400) {
                        Method reflectMethod = restMethodMetadata.getReflectMethod();
                        mediaType = MediaTypeUtil.convertMediaType(reflectMethod.getReturnType(), r.getContentType());
                        Object value = HttpMessageCodecManager.httpMessageDecode(r.getBody(), reflectMethod.getReturnType(), reflectMethod.getGenericReturnType(), mediaType);
                        appResponse.setValue(value);
                        HttpHeaderUtil.parseResponseHeader(appResponse, r);
                        responseFuture.complete(appResponse);
                    }
                }
                catch (Exception e) {
                    responseFuture.completeExceptionally(e);
                }
            }
        });
        return asyncRpcResult;
    }

    private HttpConnectionCreateContext createHttpConnectionCreateContext(Invocation invocation, ServiceRestMetadata serviceRestMetadata, RestMethodMetadata restMethodMetadata, RequestTemplate requestTemplate) {
        HttpConnectionCreateContext httpConnectionCreateContext = new HttpConnectionCreateContext();
        httpConnectionCreateContext.setRequestTemplate(requestTemplate);
        httpConnectionCreateContext.setRestMethodMetadata(restMethodMetadata);
        httpConnectionCreateContext.setServiceRestMetadata(serviceRestMetadata);
        httpConnectionCreateContext.setInvocation(invocation);
        httpConnectionCreateContext.setUrl(this.getUrl());
        return httpConnectionCreateContext;
    }
}

