/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.config;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.CommonConfigPostProcessor;
import org.apache.dubbo.config.ReferenceConfigBase;

@Activate
public class FeignClientAnnotationConfigPostProcessor
implements CommonConfigPostProcessor {
    public void postProcessReferConfig(ReferenceConfigBase referenceConfig) {
        FeignClientAnnotationConfigPostProcessor.appendParametersFromInterfaceClassMetadata(referenceConfig.getInterfaceClass(), referenceConfig);
    }

    public static void appendParametersFromInterfaceClassMetadata(Class<?> interfaceClass, ReferenceConfigBase referenceConfig) {
        if (interfaceClass == null) {
            return;
        }
        Class feignClientAnno = ClassUtils.forNameAndTryCatch((String)"org.springframework.cloud.openfeign.FeignClient");
        if (feignClientAnno == null || !AnnotationUtils.isAnnotationPresent(interfaceClass, (Class)feignClientAnno)) {
            return;
        }
        Object annotation = interfaceClass.getAnnotation(feignClientAnno);
        String serviceName = (String)AnnotationUtils.getAttribute(annotation, (String[])new String[]{"name", "value"});
        if (StringUtils.isEmpty((String)serviceName)) {
            return;
        }
        referenceConfig.setProvidedBy(serviceName);
    }
}

