/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.deploy;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;

public class ServiceDeployerManager {
    private static final ConcurrentMap<String, ServiceDeployer> serviceDeployers = new ConcurrentHashMap<String, ServiceDeployer>();

    public static URL deploy(URL currentURL, ServiceRestMetadata serviceRestMetadata, Invoker invoker) {
        AtomicBoolean isNewCreate = new AtomicBoolean();
        ServiceDeployer newServiceDeployer = (ServiceDeployer)ConcurrentHashMapUtils.computeIfAbsent(serviceDeployers, (Object)currentURL.getAddress(), address -> {
            ServiceDeployer serviceDeployer = new ServiceDeployer();
            isNewCreate.set(true);
            return serviceDeployer;
        });
        newServiceDeployer.deploy(serviceRestMetadata, invoker);
        newServiceDeployer.registerExtension(currentURL);
        currentURL = currentURL.putAttribute("restServiceDeployerAttributeKey", (Object)newServiceDeployer);
        if (!isNewCreate.get()) {
            return currentURL;
        }
        URL tmp = currentURL;
        if (Constants.REST_SERVER.contains(tmp.getParameter("server"))) {
            tmp = tmp.addParameter("server", "netty4");
        }
        return tmp;
    }

    public static void close() {
        serviceDeployers.clear();
    }
}

