/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.request;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.dubbo.common.utils.IOUtils;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;

public class NettyRequestFacade
extends RequestFacade<FullHttpRequest> {
    private ChannelHandlerContext context;

    public NettyRequestFacade(Object request, ChannelHandlerContext context) {
        super((FullHttpRequest)request);
        this.context = context;
    }

    public NettyRequestFacade(Object request, ChannelHandlerContext context, ServiceDeployer serviceDeployer) {
        super((FullHttpRequest)request, serviceDeployer);
        this.context = context;
    }

    @Override
    protected void initHeaders() {
        for (Map.Entry header : ((FullHttpRequest)this.request).headers()) {
            String key = (String)header.getKey();
            ArrayList<String> tmpHeaders = (ArrayList<String>)this.headers.get(key);
            if (tmpHeaders == null) {
                tmpHeaders = new ArrayList<String>();
                this.headers.put(key, tmpHeaders);
            }
            tmpHeaders.add((String)header.getValue());
        }
    }

    @Override
    public String getHeader(String name) {
        List values = (List)this.headers.get(name);
        if (values == null && name != null) {
            values = (List)this.headers.get(name.toLowerCase());
        }
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        ArrayList list = (ArrayList)this.headers.get(name);
        if (list == null) {
            list = new ArrayList();
        }
        final ListIterator stringListIterator = list.listIterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return stringListIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)stringListIterator.next();
            }
        };
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        final Iterator strings = this.headers.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return strings.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)strings.next();
            }
        };
    }

    @Override
    public String getMethod() {
        return ((FullHttpRequest)this.request).method().name();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getContextPath() {
        return null;
    }

    @Override
    public String getRequestURI() {
        return ((FullHttpRequest)this.request).uri();
    }

    @Override
    public String getParameter(String name) {
        ArrayList strings = (ArrayList)this.parameters.get(name);
        String value = null;
        if (strings != null && !strings.isEmpty()) {
            value = (String)strings.get(0);
        }
        return value;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        final Iterator iterator = this.parameters.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    @Override
    public String[] getParameterValues(String name) {
        if (!this.parameters.containsKey(name)) {
            return null;
        }
        return ((ArrayList)this.parameters.get(name)).toArray(new String[0]);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        this.parameters.entrySet().forEach(entry -> map.put((String)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0])));
        return map;
    }

    @Override
    public String getRemoteAddr() {
        return this.getChannel().remoteAddress().getHostString();
    }

    @Override
    public String getRemoteHost() {
        return this.getRemoteAddr() + ":" + this.getRemotePort();
    }

    @Override
    public int getRemotePort() {
        return this.getChannel().remoteAddress().getPort();
    }

    @Override
    public String getLocalAddr() {
        return this.getChannel().localAddress().getHostString();
    }

    @Override
    public String getLocalHost() {
        return this.getRemoteAddr() + ":" + this.getLocalPort();
    }

    private NioSocketChannel getChannel() {
        return (NioSocketChannel)this.context.channel();
    }

    @Override
    public int getLocalPort() {
        return this.getChannel().localAddress().getPort();
    }

    @Override
    public byte[] getInputStream() throws IOException {
        return this.body;
    }

    @Override
    protected void parseBody() {
        ByteBuf byteBuf = ((HttpContent)this.request).content();
        if (byteBuf.readableBytes() > 0) {
            try {
                this.body = IOUtils.toByteArray((InputStream)new ByteBufInputStream(byteBuf));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ChannelHandlerContext getNettyChannelContext() {
        return this.context;
    }
}

