/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http1;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpInputMessage;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.h1.Http1ServerChannelObserver;
import org.apache.dubbo.remoting.http12.h1.Http1ServerStreamChannelObserver;
import org.apache.dubbo.remoting.http12.h1.Http1ServerTransportListener;
import org.apache.dubbo.remoting.http12.message.DefaultListeningDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.ListeningDecoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.h12.AbstractServerTransportListener;
import org.apache.dubbo.rpc.protocol.tri.h12.DefaultHttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.UnaryServerCallListener;

public class DefaultHttp11ServerTransportListener
extends AbstractServerTransportListener<RequestMetadata, HttpInputMessage>
implements Http1ServerTransportListener {
    private final HttpChannel httpChannel;
    private final URL url;

    public DefaultHttp11ServerTransportListener(HttpChannel httpChannel, URL url, FrameworkModel frameworkModel) {
        super(frameworkModel, url, httpChannel);
        this.url = url;
        this.httpChannel = httpChannel;
    }

    private ServerCallListener startListener(RpcInvocation invocation, MethodDescriptor methodDescriptor, Invoker<?> invoker) {
        switch (methodDescriptor.getRpcType()) {
            case UNARY: {
                Http1ServerChannelObserver http1ChannelObserver = new Http1ServerChannelObserver(this.httpChannel);
                http1ChannelObserver.setHttpMessageCodec(this.getHttpMessageCodec());
                return new AutoCompleteUnaryServerCallListener(invocation, invoker, (StreamObserver<Object>)http1ChannelObserver);
            }
            case SERVER_STREAM: {
                Http1ServerStreamChannelObserver serverStreamChannelObserver = new Http1ServerStreamChannelObserver(this.httpChannel);
                serverStreamChannelObserver.setHttpMessageCodec(this.getHttpMessageCodec());
                serverStreamChannelObserver.setHeadersCustomizer(headers -> headers.set(HttpHeaderNames.CONTENT_TYPE.getName(), MediaType.TEXT_EVENT_STREAM_VALUE.getName()));
                return new AutoCompleteServerStreamServerCallListener(invocation, invoker, (StreamObserver<Object>)serverStreamChannelObserver);
            }
        }
        throw new UnsupportedOperationException("HTTP1.x only support unary and server-stream");
    }

    @Override
    protected HttpMessageListener newHttpMessageListener() {
        Object httpMetadata = this.getHttpMetadata();
        String path = httpMetadata.path();
        String[] parts = path.split("/");
        String originalMethodName = parts[2];
        boolean hasStub = this.getPathResolver().hasNativeStub(path);
        MethodDescriptor methodDescriptor = DefaultHttp11ServerTransportListener.findMethodDescriptor(this.getServiceDescriptor(), originalMethodName, hasStub);
        MethodMetadata methodMetadata = MethodMetadata.fromMethodDescriptor((MethodDescriptor)methodDescriptor);
        RpcInvocation rpcInvocation = this.buildRpcInvocation(this.getInvoker(), this.getServiceDescriptor(), methodDescriptor);
        this.setMethodDescriptor(methodDescriptor);
        this.setMethodMetadata(methodMetadata);
        this.setRpcInvocation(rpcInvocation);
        HttpMessageCodec httpMessageCodec = this.getHttpMessageCodec();
        ListeningDecoder listeningDecoder = this.newListeningDecoder(httpMessageCodec, methodMetadata.getActualRequestTypes());
        return new DefaultHttpMessageListener(listeningDecoder);
    }

    private ListeningDecoder newListeningDecoder(HttpMessageCodec codec, Class<?>[] actualRequestTypes) {
        DefaultListeningDecoder defaultListeningDecoder = new DefaultListeningDecoder(codec, (Class[])actualRequestTypes);
        ServerCallListener serverCallListener = this.startListener(this.getRpcInvocation(), this.getMethodDescriptor(), this.getInvoker());
        defaultListeningDecoder.setListener(serverCallListener::onMessage);
        return defaultListeningDecoder;
    }

    private static class AutoCompleteUnaryServerCallListener
    extends UnaryServerCallListener {
        public AutoCompleteUnaryServerCallListener(RpcInvocation invocation, Invoker<?> invoker, StreamObserver<Object> responseObserver) {
            super(invocation, invoker, responseObserver);
        }

        @Override
        public void onMessage(Object message) {
            super.onMessage(message);
            super.onComplete();
        }
    }

    private static class AutoCompleteServerStreamServerCallListener
    extends ServerStreamServerCallListener {
        public AutoCompleteServerStreamServerCallListener(RpcInvocation invocation, Invoker<?> invoker, StreamObserver<Object> responseObserver) {
            super(invocation, invoker, responseObserver);
        }

        @Override
        public void onMessage(Object message) {
            super.onMessage(message);
            super.onComplete();
        }
    }
}

