/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcServiceContext;

@Activate(group={"provider"}, order=-29000)
public class HttpContextFilter
implements Filter,
BaseFilter.Listener {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (invocation.get((Object)"tri.handler.type") == null) {
            return invoker.invoke(invocation);
        }
        HttpRequest request = (HttpRequest)invocation.get((Object)"tri.http.request");
        HttpResponse response = (HttpResponse)invocation.get((Object)"tri.http.response");
        RpcServiceContext context = RpcContext.getServiceContext();
        context.setRemoteAddress(request.remoteHost(), request.remotePort());
        if (context.getLocalAddress() == null) {
            context.setLocalAddress(request.localHost(), request.localPort());
        }
        context.setRequest((Object)request);
        context.setResponse((Object)response);
        return invoker.invoke(invocation);
    }

    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        if (invocation.get((Object)"tri.handler.type") == null) {
            return;
        }
        HttpResponse response = (HttpResponse)invocation.get((Object)"tri.http.response");
        if (response.isEmpty()) {
            return;
        }
        if (response.isContentEmpty()) {
            if (appResponse.hasException()) {
                return;
            }
            response.setBody(appResponse.getValue());
        }
        response.commit();
        HttpResult result = response.toHttpResult();
        if (result.getBody() instanceof Throwable) {
            appResponse.setException((Throwable)result.getBody());
            return;
        }
        appResponse.setValue((Object)result);
        appResponse.setException(null);
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

