/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.grpc.health.v1.HealthCheckResponse;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.api.pu.DefaultPuHandler;
import org.apache.dubbo.remoting.exchange.Http3Exchanger;
import org.apache.dubbo.remoting.exchange.PortUnificationExchanger;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.AbstractExporter;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.tri.ServletExchanger;
import org.apache.dubbo.rpc.protocol.tri.TripleInvoker;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.DefaultRequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.service.TriBuiltinService;

public class TripleProtocol
extends AbstractProtocol {
    private static final Logger logger = LoggerFactory.getLogger(TripleProtocol.class);
    private final PathResolver pathResolver;
    private final RequestMappingRegistry mappingRegistry;
    private final TriBuiltinService triBuiltinService;
    private final String acceptEncodings;
    public static boolean CONVERT_NO_LOWER_HEADER = false;
    public static boolean IGNORE_1_0_0_VERSION = false;
    public static boolean RESOLVE_FALLBACK_TO_DEFAULT = true;
    public static boolean PASS_THROUGH_STANDARD_HTTP_HEADERS = false;
    public static boolean HTTP3_ENABLED = false;
    public static boolean SERVLET_ENABLED = false;

    public TripleProtocol(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.triBuiltinService = new TriBuiltinService(frameworkModel);
        this.pathResolver = (PathResolver)frameworkModel.getDefaultExtension(PathResolver.class);
        this.mappingRegistry = (RequestMappingRegistry)frameworkModel.getBeanFactory().getOrRegisterBean(DefaultRequestMappingRegistry.class);
        Set supported = frameworkModel.getExtensionLoader(DeCompressor.class).getSupportedExtensions();
        this.acceptEncodings = String.join((CharSequence)",", supported);
        Configuration conf = ConfigurationUtils.getEnvConfiguration((ScopeModel)ApplicationModel.defaultModel());
        CONVERT_NO_LOWER_HEADER = conf.getBoolean("dubbo.rpc.tri.support-no-lower-header", true);
        IGNORE_1_0_0_VERSION = conf.getBoolean("dubbo.rpc.tri.ignore-1.0.0-version", false);
        RESOLVE_FALLBACK_TO_DEFAULT = conf.getBoolean("dubbo.rpc.tri.resolve-fallback-to-default", true);
        PASS_THROUGH_STANDARD_HTTP_HEADERS = conf.getBoolean("dubbo.rpc.tri.pass-through-standard-http-headers", false);
        Configuration globalConf = ConfigurationUtils.getGlobalConfiguration((ScopeModel)frameworkModel.defaultApplication());
        HTTP3_ENABLED = globalConf.getBoolean("dubbo.protocol.triple.enable-http3", false);
        SERVLET_ENABLED = globalConf.getBoolean("dubbo.protocol.triple.enable-servlet", false);
    }

    public int getDefaultPort() {
        return 50051;
    }

    public <T> Exporter<T> export(final Invoker<T> invoker) throws RpcException {
        final URL url = invoker.getUrl();
        final String key = TripleProtocol.serviceKey((URL)url);
        AbstractExporter exporter = new AbstractExporter<T>(invoker){

            public void afterUnExport() {
                TripleProtocol.this.pathResolver.remove(url.getServiceKey());
                TripleProtocol.this.pathResolver.remove(url.getServiceModel().getServiceModel().getInterfaceName());
                TripleProtocol.this.mappingRegistry.unregister(invoker);
                if (TripleProtocol.this.triBuiltinService.enable()) {
                    TripleProtocol.this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceKey(), HealthCheckResponse.ServingStatus.NOT_SERVING);
                    TripleProtocol.this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceInterface(), HealthCheckResponse.ServingStatus.NOT_SERVING);
                }
                TripleProtocol.this.exporterMap.remove(key);
            }
        };
        this.exporterMap.put(key, exporter);
        this.invokers.add(invoker);
        Invoker previous = this.pathResolver.add(url.getServiceKey(), invoker);
        if (previous != null) {
            if (url.getServiceKey().equals(url.getServiceModel().getServiceModel().getInterfaceName())) {
                logger.info("Already exists an invoker[" + previous.getUrl() + "] on path[" + url.getServiceKey() + "], dubbo will override with invoker[" + url + "]");
            } else {
                throw new IllegalStateException("Already exists an invoker[" + previous.getUrl() + "] on path[" + url.getServiceKey() + "], failed to add invoker[" + url + "] , please use unique serviceKey.");
            }
        }
        if (RESOLVE_FALLBACK_TO_DEFAULT) {
            previous = this.pathResolver.addIfAbsent(url.getServiceModel().getServiceModel().getInterfaceName(), invoker);
            if (previous != null) {
                logger.info("Already exists an invoker[" + previous.getUrl() + "] on path[" + url.getServiceModel().getServiceModel().getInterfaceName() + "], dubbo will skip override with invoker[" + url + "]");
            } else {
                logger.info("Add fallback triple invoker[" + url + "] to path[" + url.getServiceModel().getServiceModel().getInterfaceName() + "] with invoker[" + url + "]");
            }
        }
        this.mappingRegistry.register(invoker);
        if (this.triBuiltinService.enable()) {
            this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceKey(), HealthCheckResponse.ServingStatus.SERVING);
            this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceInterface(), HealthCheckResponse.ServingStatus.SERVING);
        }
        ExecutorRepository.getInstance((ApplicationModel)url.getOrDefaultApplicationModel()).createExecutorIfAbsent(ExecutorUtil.setThreadName((URL)url, (String)"DubboServerHandler"));
        boolean bindPort = true;
        if (SERVLET_ENABLED) {
            int port = url.getParameter("bind.port", url.getPort());
            Integer serverPort = ServletExchanger.getServerPort();
            if (serverPort == null) {
                if (NetUtils.isPortInUsed((int)port)) {
                    bindPort = false;
                }
            } else if (serverPort == port) {
                bindPort = false;
            }
            ServletExchanger.bind(url);
        }
        if (bindPort) {
            PortUnificationExchanger.bind((URL)url, (ChannelHandler)new DefaultPuHandler());
        }
        if (TripleProtocol.isHttp3Enabled(url)) {
            Http3Exchanger.bind((URL)url);
        }
        this.optimizeSerialization(url);
        return exporter;
    }

    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        this.optimizeSerialization(url);
        ExecutorService streamExecutor = this.getOrCreateStreamExecutor(url.getOrDefaultApplicationModel(), url);
        AbstractConnectionClient connectionClient = TripleProtocol.isHttp3Enabled(url) ? Http3Exchanger.connect((URL)url) : PortUnificationExchanger.connect((URL)url, (ChannelHandler)new DefaultPuHandler());
        TripleInvoker<T> invoker = new TripleInvoker<T>(type, url, this.acceptEncodings, connectionClient, this.invokers, streamExecutor);
        this.invokers.add(invoker);
        return invoker;
    }

    private ExecutorService getOrCreateStreamExecutor(ApplicationModel applicationModel, URL url) {
        url = url.addParameter("threadname", "DubboClientHandler").addParameterIfAbsent("threadpool", "cached");
        ExecutorService executor = ExecutorRepository.getInstance((ApplicationModel)applicationModel).createExecutorIfAbsent(url);
        Objects.requireNonNull(executor, String.format("No available executor found in %s", url));
        return executor;
    }

    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, URL url) throws RpcException {
        return null;
    }

    public void destroy() {
        if (logger.isInfoEnabled()) {
            logger.info("Destroying protocol [" + ((Object)((Object)this)).getClass().getSimpleName() + "] ...");
        }
        PortUnificationExchanger.close();
        Http3Exchanger.close();
        this.pathResolver.destroy();
        this.mappingRegistry.destroy();
        super.destroy();
    }

    public static boolean isHttp3Enabled(URL url) {
        return HTTP3_ENABLED || url.getParameter("http3", false);
    }
}

