/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.codec.CodecUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.DescriptorUtils;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageDecoderWrapper;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageEncoderWrapper;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandler;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandlerMapping;

@Activate(order=-1000)
public class HttpRequestHandlerMapping
implements RequestHandlerMapping {
    private final FrameworkModel frameworkModel;
    private final PathResolver pathResolver;
    private final CodecUtils codecUtils;

    public HttpRequestHandlerMapping(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.pathResolver = (PathResolver)frameworkModel.getDefaultExtension(PathResolver.class);
        this.codecUtils = (CodecUtils)frameworkModel.getBeanFactory().getOrRegisterBean(CodecUtils.class);
    }

    @Override
    public RequestHandler getRequestHandler(URL url, HttpRequest request, HttpResponse response) {
        if (!this.supportContentType(request.contentType())) {
            return null;
        }
        String uri = request.uri();
        int index = uri.indexOf(47, 1);
        if (index == -1) {
            return null;
        }
        if (uri.indexOf(47, index + 1) != -1) {
            return null;
        }
        String serviceName = uri.substring(1, index);
        String version = request.header(TripleHeaderEnum.SERVICE_VERSION.getHeader());
        String group = request.header(TripleHeaderEnum.SERVICE_GROUP.getHeader());
        String key = URL.buildKey((String)serviceName, (String)group, (String)version);
        Invoker invoker = this.pathResolver.resolve(key);
        if (invoker == null && TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT && (invoker = this.pathResolver.resolve(URL.buildKey((String)serviceName, (String)group, (String)"1.0.0"))) == null && (invoker = this.pathResolver.resolve(serviceName)) == null) {
            return null;
        }
        RequestHandler handler = new RequestHandler(invoker);
        handler.setHasStub(this.pathResolver.hasNativeStub(uri));
        handler.setMethodName(uri.substring(index + 1));
        handler.setServiceDescriptor(DescriptorUtils.findServiceDescriptor(invoker, serviceName, handler.isHasStub()));
        this.determineHttpMessageCodec(handler, url, request);
        return handler;
    }

    protected boolean supportContentType(String contentType) {
        return true;
    }

    protected void determineHttpMessageCodec(RequestHandler handler, URL url, HttpRequest request) {
        String mediaType = request.mediaType();
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_JSON.getName();
            request.setContentType(mediaType);
        }
        Charset charset = request.charsetOrDefault();
        HttpMessageDecoder decoder = this.codecUtils.determineHttpMessageDecoder(url, this.frameworkModel, mediaType);
        HttpMessageEncoder encoder = this.codecUtils.determineHttpMessageEncoder(url, this.frameworkModel, mediaType);
        if (!StandardCharsets.UTF_8.equals(charset)) {
            decoder = new HttpMessageDecoderWrapper(charset, decoder);
            encoder = new HttpMessageEncoderWrapper(charset, encoder);
        }
        handler.setHttpMessageDecoder(decoder);
        handler.setHttpMessageEncoder(encoder);
    }

    protected final FrameworkModel getFrameworkModel() {
        return this.frameworkModel;
    }

    @Override
    public String getType() {
        return "http";
    }
}

