/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.ProtobufHttpMessageCodec;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.WrapperHttpMessageCodec;

public class GrpcCompositeCodec
implements HttpMessageCodec {
    private final ProtobufHttpMessageCodec protobufHttpMessageCodec;
    private final WrapperHttpMessageCodec wrapperHttpMessageCodec;

    public GrpcCompositeCodec(ProtobufHttpMessageCodec protobufHttpMessageCodec, WrapperHttpMessageCodec wrapperHttpMessageCodec) {
        this.protobufHttpMessageCodec = protobufHttpMessageCodec;
        this.wrapperHttpMessageCodec = wrapperHttpMessageCodec;
    }

    public void setEncodeTypes(Class<?>[] encodeTypes) {
        this.wrapperHttpMessageCodec.setEncodeTypes(encodeTypes);
    }

    public void setDecodeTypes(Class<?>[] decodeTypes) {
        this.wrapperHttpMessageCodec.setDecodeTypes(decodeTypes);
    }

    public void encode(OutputStream outputStream, Object data, Charset charset) throws EncodeException {
        try {
            int compressed = 0;
            outputStream.write(compressed);
            if (GrpcCompositeCodec.isProtobuf(data)) {
                ProtobufWriter.write(this.protobufHttpMessageCodec, outputStream, data);
                return;
            }
            this.wrapperHttpMessageCodec.encode(outputStream, data);
        }
        catch (IOException e) {
            throw new EncodeException((Throwable)e);
        }
    }

    public Object decode(InputStream inputStream, Class<?> targetType, Charset charset) throws DecodeException {
        if (GrpcCompositeCodec.isProtoClass(targetType)) {
            return this.protobufHttpMessageCodec.decode(inputStream, targetType, charset);
        }
        return this.wrapperHttpMessageCodec.decode(inputStream, targetType, charset);
    }

    public Object[] decode(InputStream inputStream, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        if (targetTypes.length > 1) {
            return this.wrapperHttpMessageCodec.decode(inputStream, targetTypes, charset);
        }
        return super.decode(inputStream, (Class[])targetTypes, charset);
    }

    private static void writeLength(OutputStream outputStream, int length) {
        try {
            outputStream.write(length >> 24 & 0xFF);
            outputStream.write(length >> 16 & 0xFF);
            outputStream.write(length >> 8 & 0xFF);
            outputStream.write(length & 0xFF);
        }
        catch (IOException e) {
            throw new EncodeException((Throwable)e);
        }
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_GRPC;
    }

    private static boolean isProtobuf(Object data) {
        if (data == null) {
            return false;
        }
        return GrpcCompositeCodec.isProtoClass(data.getClass());
    }

    private static boolean isProtoClass(Class<?> clazz) {
        while (clazz != Object.class && clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length > 0) {
                for (Class<?> clazzInterface : interfaces) {
                    if (!"com.google.protobuf.Message".equalsIgnoreCase(clazzInterface.getName())) continue;
                    return true;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private static class ProtobufWriter {
        private ProtobufWriter() {
        }

        private static void write(HttpMessageCodec codec, OutputStream outputStream, Object data) {
            int serializedSize = ((Message)data).getSerializedSize();
            GrpcCompositeCodec.writeLength(outputStream, serializedSize);
            codec.encode(outputStream, data);
        }
    }
}

