/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoderFactory;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoderFactory;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcCompositeCodec;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.ProtobufHttpMessageCodec;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.WrapperHttpMessageCodec;

@Activate
public class GrpcCompositeCodecFactory
implements HttpMessageEncoderFactory,
HttpMessageDecoderFactory {
    public HttpMessageCodec createCodec(URL url, FrameworkModel frameworkModel, String mediaType) {
        String serializeName = UrlUtils.serializationOrDefault((URL)url);
        WrapperHttpMessageCodec wrapperHttpMessageCodec = new WrapperHttpMessageCodec(url, frameworkModel);
        wrapperHttpMessageCodec.setSerializeType(serializeName);
        ProtobufHttpMessageCodec protobufHttpMessageCodec = new ProtobufHttpMessageCodec();
        return new GrpcCompositeCodec(protobufHttpMessageCodec, wrapperHttpMessageCodec);
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_GRPC;
    }
}

