/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpRequestHandlerMapping;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcCompositeCodecFactory;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandler;

@Activate(order=-3000)
public final class GrpcRequestHandlerMapping
extends HttpRequestHandlerMapping {
    public static final GrpcCompositeCodecFactory CODEC_FACTORY = new GrpcCompositeCodecFactory();

    public GrpcRequestHandlerMapping(FrameworkModel frameworkModel) {
        super(frameworkModel);
    }

    @Override
    protected boolean supportContentType(String contentType) {
        return contentType != null && contentType.startsWith(MediaType.APPLICATION_GRPC.getName());
    }

    @Override
    protected void determineHttpMessageCodec(RequestHandler handler, URL url, HttpRequest request) {
        HttpMessageCodec codec = CODEC_FACTORY.createCodec(url, this.getFrameworkModel(), request.contentType());
        handler.setHttpMessageDecoder((HttpMessageDecoder)codec);
        handler.setHttpMessageEncoder((HttpMessageEncoder)codec);
    }

    @Override
    public String getType() {
        return "grpc";
    }
}

