/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.protocol.tri.SingleProtobufUtils;

public class ProtobufHttpMessageCodec
implements HttpMessageCodec {
    private static final MediaType MEDIA_TYPE = new MediaType("application", "x-protobuf");

    public void encode(OutputStream outputStream, Object data, Charset charset) throws EncodeException {
        try {
            SingleProtobufUtils.serialize(data, outputStream);
        }
        catch (IOException e) {
            throw new EncodeException((Throwable)e);
        }
    }

    public Object decode(InputStream inputStream, Class<?> targetType, Charset charset) throws DecodeException {
        try {
            return SingleProtobufUtils.deserialize(inputStream, targetType);
        }
        catch (IOException e) {
            throw new DecodeException((Throwable)e);
        }
    }

    public MediaType mediaType() {
        return MEDIA_TYPE;
    }
}

