/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.TripleCustomerProtocolWapper;

public class WrapperHttpMessageCodec
implements HttpMessageCodec {
    private static final MediaType MEDIA_TYPE = new MediaType("application", "triple+wrapper");
    private static final String DEFAULT_SERIALIZE_TYPE = "fastjson2";
    private final MultipleSerialization serialization;
    private final URL url;
    private Class<?>[] encodeTypes;
    private Class<?>[] decodeTypes;
    private String serializeType = "fastjson2";

    public WrapperHttpMessageCodec(URL url, FrameworkModel frameworkModel) {
        this.url = url;
        this.serialization = (MultipleSerialization)frameworkModel.getExtensionLoader(MultipleSerialization.class).getExtension(url.getParameter("serialize.multiple", "default"));
    }

    public void setSerializeType(String serializeType) {
        this.serializeType = serializeType;
    }

    public void setEncodeTypes(Class<?>[] encodeTypes) {
        this.encodeTypes = encodeTypes;
    }

    public void setDecodeTypes(Class<?>[] decodeTypes) {
        this.decodeTypes = decodeTypes;
    }

    public void encode(OutputStream outputStream, Object data, Charset charset) throws EncodeException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.serialization.serialize(this.url, this.serializeType, this.encodeTypes[0], data, (OutputStream)bos);
            byte[] encoded = TripleCustomerProtocolWapper.TripleResponseWrapper.Builder.newBuilder().setSerializeType(this.serializeType).setType(this.encodeTypes[0].getName()).setData(bos.toByteArray()).build().toByteArray();
            WrapperHttpMessageCodec.writeLength(outputStream, encoded.length);
            outputStream.write(encoded);
        }
        catch (IOException e) {
            throw new EncodeException((Throwable)e);
        }
    }

    public void encode(OutputStream outputStream, Object[] data, Charset charset) throws EncodeException {
    }

    public Object decode(InputStream inputStream, Class<?> targetType, Charset charset) throws DecodeException {
        Object[] decode = this.decode(inputStream, new Class[]{targetType}, charset);
        if (decode == null || decode.length == 0) {
            return null;
        }
        return decode[0];
    }

    public Object[] decode(InputStream inputStream, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        try {
            int len;
            byte[] data = new byte[4096];
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            while ((len = inputStream.read(data)) != -1) {
                bos.write(data, 0, len);
            }
            TripleCustomerProtocolWapper.TripleRequestWrapper wrapper = TripleCustomerProtocolWapper.TripleRequestWrapper.parseFrom(bos.toByteArray());
            String serializeType = WrapperHttpMessageCodec.convertHessianFromWrapper(wrapper.getSerializeType());
            CodecSupport.checkSerialization((String)serializeType, (URL)this.url);
            this.setSerializeType(wrapper.getSerializeType());
            Object[] ret = new Object[wrapper.getArgs().size()];
            for (int i = 0; i < wrapper.getArgs().size(); ++i) {
                ByteArrayInputStream in = new ByteArrayInputStream(wrapper.getArgs().get(i));
                try {
                    ret[i] = this.serialization.deserialize(this.url, wrapper.getSerializeType(), targetTypes[i], (InputStream)in);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new DecodeException((Throwable)e);
                }
            }
            return ret;
        }
        catch (IOException e) {
            throw new DecodeException((Throwable)e);
        }
    }

    public MediaType mediaType() {
        return MEDIA_TYPE;
    }

    private static void writeLength(OutputStream outputStream, int length) throws IOException {
        outputStream.write(length >> 24 & 0xFF);
        outputStream.write(length >> 16 & 0xFF);
        outputStream.write(length >> 8 & 0xFF);
        outputStream.write(length & 0xFF);
    }

    private static String convertHessianFromWrapper(String serializeType) {
        if ("hessian4".equals(serializeType)) {
            return "hessian2";
        }
        return serializeType;
    }
}

