/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;

public class RestException
extends HttpStatusException {
    private static final long serialVersionUID = 1L;
    private final Messages message;

    public RestException(Messages message, Object ... arguments) {
        super(message.statusCode(), message.format(arguments));
        this.message = message;
    }

    public RestException(Throwable cause, Messages message, Object ... arguments) {
        super(message.statusCode(), message.format(arguments), RestException.unwrap(cause));
        this.message = message;
    }

    public RestException(String message, Throwable cause) {
        super(500, message, RestException.unwrap(cause));
        this.message = Messages.INTERNAL_ERROR;
    }

    public RestException(int statusCode, String message) {
        super(statusCode, message);
        this.message = Messages.INTERNAL_ERROR;
    }

    public RestException(String message) {
        super(500, message);
        this.message = Messages.INTERNAL_ERROR;
    }

    public RestException(Throwable cause) {
        super(500, RestException.unwrap(cause));
        this.message = Messages.INTERNAL_ERROR;
    }

    public String getErrorCode() {
        return this.message.name();
    }

    public static RuntimeException wrap(Throwable t) {
        return (t = RestException.unwrap(t)) instanceof RuntimeException ? (RuntimeException)t : new RestException(t);
    }

    public static Throwable unwrap(Throwable t) {
        while (true) {
            Throwable cause;
            if (t instanceof UndeclaredThrowableException) {
                t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
                continue;
            }
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
                continue;
            }
            if (!(t instanceof CompletionException) && !(t instanceof ExecutionException) || (cause = t.getCause()) == t) break;
            t = cause;
        }
        return t;
    }
}

