/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.TypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;

public final class RestHttpMessageCodec
implements HttpMessageDecoder,
HttpMessageEncoder {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final HttpRequest request;
    private final HttpResponse response;
    private final ParameterMeta[] parameters;
    private final ArgumentResolver argumentResolver;
    private final TypeConverter typeConverter;
    private final HttpMessageEncoder messageEncoder;
    private final Charset charset;

    public RestHttpMessageCodec(HttpRequest request, HttpResponse response, ParameterMeta[] parameters, ArgumentResolver argumentResolver, TypeConverter typeConverter, HttpMessageEncoder messageEncoder) {
        this.request = request;
        this.response = response;
        this.parameters = parameters;
        this.argumentResolver = argumentResolver;
        this.typeConverter = typeConverter;
        this.messageEncoder = messageEncoder;
        this.charset = request.charsetOrDefault();
    }

    public Object decode(InputStream inputStream, Class<?> targetType, Charset charset) throws DecodeException {
        return this.decode(inputStream, new Class[]{targetType}, charset);
    }

    public Object[] decode(InputStream inputStream, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        this.request.setInputStream(inputStream);
        ParameterMeta[] parameters = this.parameters;
        int len = parameters.length;
        if (len == 0) {
            return EMPTY_ARGS;
        }
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            args[i] = this.argumentResolver.resolve(parameters[i], this.request, this.response);
        }
        return args;
    }

    public void encode(OutputStream os, Object data, Charset charset) throws EncodeException {
        this.encode(os, data);
    }

    public void encode(OutputStream os, Object data) throws EncodeException {
        if (data != null) {
            Class<?> type = data.getClass();
            try {
                if (type == byte[].class) {
                    os.write((byte[])data);
                    return;
                }
                if (type == ByteArrayOutputStream.class) {
                    ((ByteArrayOutputStream)data).writeTo(os);
                    return;
                }
                if (data instanceof InputStream) {
                    try (InputStream is = (InputStream)data;){
                        StreamUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    return;
                }
                if (this.messageEncoder.mediaType().isPureText() && type != String.class) {
                    data = this.typeConverter.convert(data, String.class);
                }
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EncodeException((Throwable)e);
            }
        }
        this.messageEncoder.encode(os, data, this.charset);
    }

    public MediaType mediaType() {
        return this.messageEncoder.mediaType();
    }

    public String contentType() {
        String contentType = this.response.contentType();
        return contentType == null ? this.messageEncoder.contentType() : contentType;
    }
}

