/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.argument;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestParameterException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public abstract class NamedValueArgumentResolverSupport {
    protected final Map<ParameterMeta, NamedValueMeta> cache = CollectionUtils.newConcurrentHashMap();

    protected final Object resolve(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Class<?> type = meta.type();
        Object arg = type.isArray() || Collection.class.isAssignableFrom(type) ? this.resolveCollectionValue(meta, request, response) : (Map.class.isAssignableFrom(type) ? this.resolveMapValue(meta, request, response) : this.resolveValue(meta, request, response));
        if (arg != null) {
            return "".equals(arg) ? meta.defaultValue() : arg;
        }
        arg = meta.defaultValue();
        if (arg != null) {
            return arg;
        }
        if (meta.required()) {
            throw new RestParameterException(Messages.ARGUMENT_VALUE_MISSING, meta.name(), type);
        }
        return null;
    }

    protected final NamedValueMeta updateNamedValueMeta(ParameterMeta parameterMeta, NamedValueMeta meta) {
        if (StringUtils.isEmpty((String)meta.name())) {
            meta.setName(parameterMeta.getRequiredName());
        }
        Class<?> type = parameterMeta.getType();
        Type genericType = parameterMeta.getGenericType();
        if (type == Optional.class) {
            Class<?> actualType = TypeUtils.getNestedType(genericType, 0);
            meta.setType(actualType == null ? Object.class : actualType);
        } else {
            meta.setType(type);
        }
        if (type.isArray()) {
            meta.setNestedTypes(new Class[]{type.getComponentType()});
        } else {
            meta.setNestedTypes(TypeUtils.getNestedTypes(genericType));
        }
        meta.setParameterMeta(parameterMeta);
        return meta;
    }

    protected abstract Object resolveValue(NamedValueMeta var1, HttpRequest var2, HttpResponse var3);

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return this.resolveValue(meta, request, response);
    }

    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Map<String, Object> value = this.resolveValue(meta, request, response);
        return value instanceof Map ? value : Collections.singletonMap(meta.name(), value);
    }
}

