/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.cors;

import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.CorsMeta;

public class CorsUtils {
    private CorsUtils() {
    }

    public static CorsMeta getGlobalCorsMeta(FrameworkModel frameworkModel) {
        Configuration config = ConfigurationUtils.getGlobalConfiguration((ScopeModel)frameworkModel.defaultApplication());
        String maxAge = config.getString("dubbo.rpc.rest.cors.max-age");
        return CorsMeta.builder().allowedOrigins(CorsUtils.getValues(config, "dubbo.rpc.rest.cors.allowed-origins")).allowedMethods(CorsUtils.getValues(config, "dubbo.rpc.rest.cors.allowed-methods")).allowedHeaders(CorsUtils.getValues(config, "dubbo.rpc.rest.cors.allowed-headers")).allowCredentials(config.getString("dubbo.rpc.rest.cors.allow-credentials")).exposedHeaders(CorsUtils.getValues(config, "dubbo.rpc.rest.cors.exposed-headers")).maxAge(maxAge == null ? null : Long.valueOf(maxAge)).build();
    }

    private static String[] getValues(Configuration config, String key) {
        return StringUtils.tokenize((String)config.getString(key), (char[])new char[]{','});
    }

    public static String formatOrigin(String value) {
        int last = (value = value.trim()).length() - 1;
        return last > -1 && value.charAt(last) == '/' ? value.substring(0, last) : value;
    }
}

