/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.beans.support.InstantiationStrategy;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionAccessorAware;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.RestInitializeException;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.DefaultFilterChain;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtension;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtensionAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilterAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

@Activate(group={"provider"}, order=1000)
public class RestExtensionExecutionFilter
extends RestFilterAdapter {
    private static final String KEY = RestExtensionExecutionFilter.class.getSimpleName();
    private final ApplicationModel applicationModel;
    private final List<RestExtensionAdapter<Object>> extensionAdapters;

    public RestExtensionExecutionFilter(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.extensionAdapters = applicationModel.getActivateExtensions(RestExtensionAdapter.class);
    }

    @Override
    protected Result invoke(Invoker<?> invoker, Invocation invocation, HttpRequest request, HttpResponse response) throws RpcException {
        RestFilter[] filters = this.getFilters(invoker);
        DefaultFilterChain chain = new DefaultFilterChain(filters, invocation, () -> invoker.invoke(invocation));
        invocation.put((Object)KEY, (Object)chain);
        try {
            Result result = chain.execute(request, response);
            if (result != null) {
                return result;
            }
            Object body = response.body();
            if (body instanceof Throwable) {
                response.setBody(null);
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)((Throwable)body), (Invocation)invocation);
            }
            if (body instanceof CompletableFuture) {
                CompletableFuture future = (CompletableFuture)body;
                response.setBody(null);
                return new AsyncRpcResult((CompletableFuture)future.handleAsync((v, t) -> {
                    AppResponse r = new AppResponse(invocation);
                    if (t != null) {
                        r.setException(t);
                    } else {
                        r.setValue(v);
                    }
                    return r;
                }), invocation);
            }
            return AsyncRpcResult.newDefaultAsyncResult((Invocation)invocation);
        }
        catch (Throwable t2) {
            throw RestException.wrap(t2);
        }
    }

    @Override
    protected void onResponse(Result result, Invoker<?> invoker, Invocation invocation, HttpRequest request, HttpResponse response) {
        Object body;
        DefaultFilterChain chain = (DefaultFilterChain)invocation.get((Object)KEY);
        if (chain == null) {
            return;
        }
        chain.onResponse(result, request, response);
        if (result.hasException() && (body = response.body()) != null) {
            if (body instanceof Throwable) {
                result.setException((Throwable)body);
            } else {
                result.setValue(body);
                result.setException(null);
            }
            response.setBody(null);
        }
    }

    @Override
    protected void onError(Throwable t, Invoker<?> invoker, Invocation invocation, HttpRequest request, HttpResponse response) {
        DefaultFilterChain chain = (DefaultFilterChain)invocation.get((Object)KEY);
        if (chain == null) {
            return;
        }
        chain.onError(t, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestFilter[] getFilters(Invoker<?> invoker) {
        URL url = invoker.getUrl();
        RestFilter[] filters = this.getFilters(url);
        if (filters != null) {
            return filters;
        }
        Invoker<?> invoker2 = invoker;
        synchronized (invoker2) {
            filters = this.getFilters(url);
            if (filters != null) {
                return filters;
            }
            filters = this.loadFilters(url);
            url.putAttribute("restExtensionsAttributeKey", (Object)filters);
            return filters;
        }
    }

    private RestFilter[] getFilters(URL url) {
        return (RestFilter[])url.getAttribute("restExtensionsAttributeKey");
    }

    private RestFilter[] loadFilters(URL url) {
        ArrayList<RestFilter> extensions = new ArrayList<RestFilter>();
        String extensionConfig = url.getParameter("extension");
        InstantiationStrategy strategy = new InstantiationStrategy(() -> this.applicationModel);
        for (String className : StringUtils.tokenize((String)extensionConfig, (char[])new char[0])) {
            try {
                Object extension = strategy.instantiate(TypeUtils.loadClass(className));
                if (extension instanceof ExtensionAccessorAware) {
                    ((ExtensionAccessorAware)extension).setExtensionAccessor((ExtensionAccessor)this.applicationModel);
                }
                this.adaptExtension(extension, extensions);
            }
            catch (Throwable t) {
                throw new RestInitializeException(t, Messages.EXTENSION_INIT_FAILED, className, url);
            }
        }
        List restExtensions = this.applicationModel.getExtensionLoader(RestExtension.class).getActivateExtension(url, "rest.filter");
        for (RestExtension extension : restExtensions) {
            this.adaptExtension(extension, extensions);
        }
        extensions.sort(Comparator.comparingInt(RestUtils::getPriority));
        return extensions.toArray(new RestFilter[0]);
    }

    private void adaptExtension(Object extension, List<RestFilter> extensions) {
        if (extension instanceof Supplier) {
            extension = ((Supplier)extension).get();
        }
        if (extension instanceof RestFilter) {
            extensions.add((RestFilter)extension);
            return;
        }
        for (RestExtensionAdapter<Object> adapter : this.extensionAdapters) {
            if (!adapter.accept(extension)) continue;
            extensions.add(adapter.adapt(extension));
        }
    }
}

