/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.DescriptorUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;
import org.apache.dubbo.rpc.protocol.tri.rest.RestInitializeException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RadixTree;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMapping;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.ProducesCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.HandlerMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.MethodWalker;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;

public final class DefaultRequestMappingRegistry
implements RequestMappingRegistry {
    private final List<RequestMappingResolver> resolvers;
    private final RadixTree<Registration> tree = new RadixTree();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public DefaultRequestMappingRegistry(FrameworkModel frameworkModel) {
        this.resolvers = frameworkModel.getActivateExtensions(RequestMappingResolver.class);
    }

    @Override
    public void register(Invoker<?> invoker) {
        Object service = invoker.getUrl().getServiceModel().getProxyObject();
        new MethodWalker().walk(service.getClass(), (classes, consumer) -> {
            int size = this.resolvers.size();
            for (int i = 0; i < size; ++i) {
                RequestMappingResolver resolver = this.resolvers.get(i);
                RestToolKit toolKit = resolver.getRestToolKit();
                ServiceMeta serviceMeta = new ServiceMeta((Collection<Class<?>>)classes, service, invoker.getUrl(), toolKit);
                if (!resolver.accept(serviceMeta)) continue;
                RequestMapping classMapping = resolver.resolve(serviceMeta);
                consumer.accept(methods -> {
                    MethodMeta methodMeta = new MethodMeta((List<Method>)methods, serviceMeta);
                    RequestMapping methodMapping = resolver.resolve(methodMeta);
                    if (methodMapping == null) {
                        return;
                    }
                    if (classMapping != null) {
                        methodMapping = classMapping.combine(methodMapping);
                    }
                    this.register0(methodMapping, this.buildHandlerMeta(invoker, methodMeta));
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register0(RequestMapping mapping, HandlerMeta handler) {
        this.lock.writeLock().lock();
        try {
            Registration registration = new Registration();
            registration.mapping = mapping;
            registration.meta = handler;
            for (PathExpression path : mapping.getPathCondition().getExpressions()) {
                Registration exists = this.tree.addPath(path, registration);
                if (exists == null) continue;
                throw new RestInitializeException(Messages.DUPLICATE_MAPPING, path.getPath(), mapping, exists.mapping);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private HandlerMeta buildHandlerMeta(Invoker<?> invoker, MethodMeta methodMeta) {
        ServiceDescriptor serviceDescriptor = DescriptorUtils.getReflectionServiceDescriptor(invoker.getUrl());
        String serviceInterface = invoker.getUrl().getServiceInterface();
        Assert.notNull((Object)serviceDescriptor, (String)"ServiceDescriptor for [%s] can't be null", (Object[])new Object[]{serviceInterface});
        Method method = methodMeta.getMethod();
        MethodDescriptor methodDescriptor = serviceDescriptor.getMethod(method.getName(), (Class[])method.getParameterTypes());
        Assert.notNull((Object)methodDescriptor, (String)"MethodDescriptor for [%s] can't be null", (Object[])new Object[]{method});
        return new HandlerMeta(invoker, methodMeta, MethodMetadata.fromMethodDescriptor((MethodDescriptor)methodDescriptor), methodDescriptor, serviceDescriptor);
    }

    @Override
    public void unregister(Invoker<?> invoker) {
        this.lock.writeLock().lock();
        try {
            this.tree.remove(mapping -> mapping.meta.getInvoker() == invoker);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void destroy() {
        this.lock.writeLock().lock();
        try {
            this.tree.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandlerMeta lookup(HttpRequest request) {
        ProducesCondition producesCondition;
        String path = PathUtils.normalize(request.rawPath());
        request.setAttribute("org.springframework.web.util.UrlPathHelper.PATH", (Object)path);
        ArrayList matches = new ArrayList();
        this.lock.readLock().lock();
        try {
            this.tree.match(path, matches);
        }
        finally {
            this.lock.readLock().unlock();
        }
        int size = matches.size();
        if (size == 0) {
            return null;
        }
        ArrayList<Candidate> candidates = new ArrayList<Candidate>(size);
        for (int i = 0; i < size; ++i) {
            RadixTree.Match match = (RadixTree.Match)matches.get(i);
            RequestMapping mapping = ((Registration)match.getValue()).mapping.match(request, match.getExpression());
            if (mapping == null) continue;
            Candidate candidate = new Candidate();
            candidate.mapping = mapping;
            candidate.meta = ((Registration)match.getValue()).meta;
            candidate.expression = match.getExpression();
            candidate.variableMap = match.getVariableMap();
            candidates.add(candidate);
        }
        size = candidates.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            candidates.sort((c1, c2) -> {
                int comparison = c1.expression.compareTo(c2.expression, path);
                if (comparison != 0) {
                    return comparison;
                }
                comparison = c1.mapping.compareTo(c2.mapping, request);
                if (comparison != 0) {
                    return comparison;
                }
                return c1.variableMap.size() - c2.variableMap.size();
            });
            Candidate first = (Candidate)candidates.get(0);
            Candidate second = (Candidate)candidates.get(1);
            if (first.mapping.compareTo(second.mapping, request) == 0) {
                throw new RestInitializeException(Messages.AMBIGUOUS_MAPPING, path, first.mapping, second.mapping);
            }
        }
        Candidate winner = (Candidate)candidates.get(0);
        RequestMapping mapping = winner.mapping;
        HandlerMeta handler = winner.meta;
        request.setAttribute(RestConstants.MAPPING_ATTRIBUTE, (Object)mapping);
        request.setAttribute(RestConstants.HANDLER_ATTRIBUTE, (Object)handler);
        if (!winner.variableMap.isEmpty()) {
            request.setAttribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables", winner.variableMap);
        }
        if ((producesCondition = mapping.getProducesCondition()) != null) {
            request.setAttribute("org.springframework.web.servlet.HandlerMapping.producibleMediaTypes", producesCondition.getMediaTypes());
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String path, String method) {
        ArrayList matches = new ArrayList();
        this.lock.readLock().lock();
        try {
            this.tree.match(path, matches);
        }
        finally {
            this.lock.readLock().unlock();
        }
        int size = matches.size();
        for (int i = 0; i < size; ++i) {
            if (!((Registration)((RadixTree.Match)matches.get((int)i)).getValue()).mapping.matchMethod(method)) continue;
            return true;
        }
        return false;
    }

    private static final class Registration {
        RequestMapping mapping;
        HandlerMeta meta;

        private Registration() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != Registration.class) {
                return false;
            }
            return this.mapping.equals(((Registration)obj).mapping);
        }

        public int hashCode() {
            return this.mapping.hashCode();
        }
    }

    private static final class Candidate {
        RequestMapping mapping;
        HandlerMeta meta;
        PathExpression expression;
        Map<String, String> variableMap;

        private Candidate() {
        }
    }
}

