/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathSegment;

public final class RadixTree<T> {
    private final Map<String, List<Match<T>>> directPathMap = new HashMap<String, List<Match<T>>>();
    private final Node<T> root = new Node();

    public T addPath(PathExpression path, T value) {
        if (path.isDirect()) {
            List matches = this.directPathMap.computeIfAbsent(path.getPath(), k -> new ArrayList());
            int len = matches.size();
            for (int i = 0; i < len; ++i) {
                Match match = (Match)matches.get(i);
                if (!match.getValue().equals(value)) continue;
                return match.getValue();
            }
            matches.add(new Match(path, (Object)value));
            return null;
        }
        Node<T> current = this.root;
        PathSegment[] segments = path.getSegments();
        int len = segments.length;
        for (int i = 0; i < len; ++i) {
            Node<T> child = RadixTree.getChild(current, segments[i]);
            if (i == len - 1) {
                List values = ((Node)child).values;
                int size = values.size();
                for (int j = 0; j < size; ++j) {
                    if (!((PathExpression)((Pair)values.get(j)).getLeft()).equals(path)) continue;
                    return (T)((Pair)values.get(j)).getRight();
                }
                values.add(Pair.of((Object)path, value));
            }
            current = child;
        }
        return null;
    }

    private static <T> Node<T> getChild(Node<T> current, PathSegment segment) {
        Node child;
        if (segment.getType() == PathSegment.Type.LITERAL) {
            Key key;
            Map children = ((Node)current).children;
            child = (Node)children.get(key = new Key(segment.getValue()));
            if (child == null) {
                child = new Node();
                children.put(key, child);
            }
        } else {
            Map children = ((Node)current).fuzzyChildren;
            child = (Node)children.get(segment);
            if (child == null) {
                child = new Node();
                children.put(segment, child);
            }
        }
        return child;
    }

    public void remove(Predicate<T> tester) {
        this.directPathMap.entrySet().removeIf(entry -> {
            List values = (List)entry.getValue();
            values.removeIf(match -> tester.test(match.getValue()));
            return values.isEmpty();
        });
        this.removeRecursive(this.root, tester);
    }

    private void removeRecursive(Node<T> current, Predicate<T> tester) {
        ((Node)current).values.removeIf(pair -> tester.test(pair.getValue()));
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(((Node)current).children);
        list.add(((Node)current).fuzzyChildren);
        for (Map children : list) {
            Iterator cit = children.entrySet().iterator();
            while (cit.hasNext()) {
                Node node = (Node)cit.next().getValue();
                this.removeRecursive(node, tester);
                if (!node.isEmpty()) continue;
                cit.remove();
            }
        }
    }

    public void match(String path, List<Match<T>> matches) {
        List<Match<T>> directMatches = this.directPathMap.get(path);
        if (directMatches != null) {
            int size = directMatches.size();
            for (int i = 0; i < size; ++i) {
                matches.add(directMatches.get(i));
            }
            return;
        }
        this.matchRecursive(this.root, path, 1, new HashMap<String, String>(), matches);
    }

    public List<Match<T>> match(String path) {
        List<Match<T>> matches = this.directPathMap.get(path);
        if (matches != null) {
            return new ArrayList<Match<T>>(matches);
        }
        matches = new ArrayList<Match<T>>();
        this.matchRecursive(this.root, path, 1, new HashMap<String, String>(), matches);
        return matches;
    }

    private void matchRecursive(Node<T> current, String path, int start, Map<String, String> variableMap, List<Match<T>> matches) {
        int end = path.indexOf(47, start);
        Node node = (Node)((Node)current).children.get(new Key(path, start, end));
        if (node != null) {
            if (node.isLeaf()) {
                RadixTree.addMatch(node, variableMap, matches);
                return;
            }
            this.matchRecursive(node, path, end + 1, variableMap, matches);
        }
        if (((Node)current).fuzzyChildren.isEmpty()) {
            return;
        }
        HashMap workVariableMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : ((Node)current).fuzzyChildren.entrySet()) {
            PathSegment segment = (PathSegment)entry.getKey();
            if (!segment.match(path, start, end, workVariableMap)) continue;
            workVariableMap.putAll(variableMap);
            Node child = (Node)entry.getValue();
            if (segment.isTailMatching() || child.isLeaf()) {
                RadixTree.addMatch(child, workVariableMap, matches);
            } else {
                this.matchRecursive(child, path, end + 1, workVariableMap, matches);
            }
            if (workVariableMap.isEmpty()) continue;
            workVariableMap = new HashMap();
        }
    }

    private static <T> void addMatch(Node<T> node, Map<String, String> variableMap, List<Match<T>> matches) {
        List values = ((Node)node).values;
        variableMap = variableMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(variableMap);
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Pair pair = (Pair)values.get(i);
            matches.add(new Match<Object>((PathExpression)pair.getLeft(), pair.getRight(), variableMap));
        }
    }

    public void clear() {
        this.directPathMap.clear();
        ((Node)this.root).clear();
    }

    public boolean isEmpty() {
        return this.directPathMap.isEmpty() && ((Node)this.root).isEmpty();
    }

    private static final class Node<T> {
        private final Map<Key, Node<T>> children = new HashMap<Key, Node<T>>();
        private final Map<PathSegment, Node<T>> fuzzyChildren = new HashMap<PathSegment, Node<T>>();
        private final List<Pair<PathExpression, T>> values = new ArrayList<Pair<PathExpression, T>>();

        private Node() {
        }

        private boolean isLeaf() {
            return this.children.isEmpty() && this.fuzzyChildren.isEmpty();
        }

        private boolean isEmpty() {
            return this.isLeaf() && this.values.isEmpty();
        }

        private void clear() {
            this.children.clear();
            this.fuzzyChildren.clear();
            this.values.clear();
        }
    }

    public static final class Match<T>
    implements Comparable<Match<T>> {
        private final PathExpression expression;
        private final T value;
        private final Map<String, String> variableMap;

        Match(PathExpression expression, T value, Map<String, String> variableMap) {
            this.expression = expression;
            this.value = value;
            this.variableMap = variableMap;
        }

        private Match(PathExpression expression, T value) {
            this.expression = expression;
            this.value = value;
            this.variableMap = Collections.emptyMap();
        }

        public PathExpression getExpression() {
            return this.expression;
        }

        public T getValue() {
            return this.value;
        }

        public Map<String, String> getVariableMap() {
            return this.variableMap;
        }

        @Override
        public int compareTo(Match<T> other) {
            int comparison = this.expression.compareTo(other.getExpression());
            return comparison == 0 ? this.variableMap.size() - other.variableMap.size() : comparison;
        }
    }

    private static final class Key
    implements CharSequence {
        private final String value;
        private final int offset;
        private final int length;

        private Key(String value, int start, int end) {
            this.value = value;
            this.offset = start;
            this.length = (end == -1 ? value.length() : end) - start;
        }

        public Key(String value) {
            this.value = value;
            this.offset = 0;
            this.length = value.length();
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.value.charAt(this.offset + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.value.substring(this.offset + start, this.offset + end);
        }

        public int hashCode() {
            int h = 0;
            for (int i = 0; i < this.length; ++i) {
                h = 31 * h + this.value.charAt(this.offset + i);
            }
            return h;
        }

        public boolean equals(Object obj) {
            Key other = (Key)obj;
            return this.value.regionMatches(this.offset, other.value, other.offset, this.length);
        }

        @Override
        public String toString() {
            return this.value.substring(this.offset, this.length - this.offset);
        }
    }
}

