/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.codec.CodecUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;
import org.apache.dubbo.rpc.protocol.tri.rest.RestHttpMessageCodec;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.GeneralTypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.TypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.ContentNegotiator;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.DefaultRequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.HandlerMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandler;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandlerMapping;

@Activate(order=-2000)
public final class RestRequestHandlerMapping
implements RequestHandlerMapping {
    private final FrameworkModel frameworkModel;
    private final RequestMappingRegistry requestMappingRegistry;
    private final ArgumentResolver argumentResolver;
    private final TypeConverter typeConverter;
    private final ContentNegotiator contentNegotiator;
    private final CodecUtils codecUtils;

    public RestRequestHandlerMapping(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        this.requestMappingRegistry = (RequestMappingRegistry)beanFactory.getOrRegisterBean(DefaultRequestMappingRegistry.class);
        this.argumentResolver = (ArgumentResolver)beanFactory.getOrRegisterBean(CompositeArgumentResolver.class);
        this.typeConverter = (TypeConverter)beanFactory.getOrRegisterBean(GeneralTypeConverter.class);
        this.contentNegotiator = (ContentNegotiator)beanFactory.getOrRegisterBean(ContentNegotiator.class);
        this.codecUtils = (CodecUtils)beanFactory.getOrRegisterBean(CodecUtils.class);
    }

    @Override
    public RequestHandler getRequestHandler(URL url, HttpRequest request, HttpResponse response) {
        HandlerMeta meta = this.requestMappingRegistry.lookup(request);
        if (meta == null) {
            return null;
        }
        String requestMediaType = request.mediaType();
        String responseMediaType = this.contentNegotiator.negotiate(request);
        if (responseMediaType != null) {
            response.setContentType(responseMediaType);
        } else {
            responseMediaType = requestMediaType != null && !RequestUtils.isFormOrMultiPart(request) ? requestMediaType : MediaType.APPLICATION_JSON.getName();
        }
        RestHttpMessageCodec codec = new RestHttpMessageCodec(request, response, meta.getParameters(), this.argumentResolver, this.typeConverter, this.codecUtils.determineHttpMessageEncoder(url, this.frameworkModel, responseMediaType));
        if (HttpMethods.supportBody((String)request.method()) && !RequestUtils.isFormOrMultiPart(request)) {
            if (StringUtils.isEmpty((String)requestMediaType)) {
                requestMediaType = responseMediaType;
            }
            request.setAttribute(RestConstants.BODY_DECODER_ATTRIBUTE, (Object)this.codecUtils.determineHttpMessageDecoder(url, this.frameworkModel, requestMediaType));
        }
        RequestHandler handler = new RequestHandler(meta.getInvoker());
        handler.setHasStub(false);
        handler.setMethodDescriptor(meta.getMethodDescriptor());
        handler.setMethodMetadata(meta.getMethodMetadata());
        handler.setServiceDescriptor(meta.getServiceDescriptor());
        handler.setHttpMessageDecoder(codec);
        handler.setHttpMessageEncoder(codec);
        return handler;
    }

    @Override
    public String getType() {
        return "rest";
    }
}

