/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathParser;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathSegment;

public final class PathExpression
implements Comparable<PathExpression> {
    private final String path;
    private final PathSegment[] segments;

    private PathExpression(String path, PathSegment[] segments) {
        this.path = path;
        this.segments = segments;
    }

    public static PathExpression parse(@Nonnull String path) {
        return new PathExpression(path, PathParser.parse(path));
    }

    public String getPath() {
        return this.path;
    }

    public PathSegment[] getSegments() {
        return this.segments;
    }

    public boolean isDirect() {
        return this.segments.length == 1 && this.segments[0].getType() == PathSegment.Type.LITERAL;
    }

    public Map<String, String> match(@Nonnull String path) {
        if (this.isDirect()) {
            return this.path.equals(path) ? Collections.emptyMap() : null;
        }
        LinkedHashMap<String, String> variableMap = new LinkedHashMap<String, String>();
        int end = 0;
        for (PathSegment segment : this.segments) {
            int start;
            if (end != -1 && segment.match(path, start = end + 1, end = path.indexOf(47, start), variableMap)) continue;
            return null;
        }
        return variableMap;
    }

    public int compareTo(PathExpression other, String lookupPath) {
        boolean equalsPath = this.path.equals(lookupPath);
        boolean otherEqualsPath = other.path.equals(lookupPath);
        if (equalsPath) {
            return otherEqualsPath ? 0 : -1;
        }
        if (otherEqualsPath) {
            return 1;
        }
        return this.compareTo(other);
    }

    @Override
    public int compareTo(PathExpression other) {
        int size = this.segments.length;
        int otherSize = other.segments.length;
        for (int i = 0; i < size && i < otherSize; ++i) {
            int result = this.segments[i].compareTo(other.segments[i]);
            if (result == 0) continue;
            return result;
        }
        return otherSize - size;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != PathExpression.class) {
            return false;
        }
        return this.path.equals(((PathExpression)obj).path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        for (PathSegment segment : this.segments) {
            sb.append('/');
            if (segment.getType() == PathSegment.Type.VARIABLE) {
                sb.append('{').append(segment.getValue()).append('}');
                continue;
            }
            sb.append(segment.getValue());
        }
        return sb.toString();
    }
}

