/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.Objects;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;

public final class ServiceVersionCondition
implements Condition<ServiceVersionCondition, HttpRequest> {
    private final String group;
    private final String version;

    public ServiceVersionCondition(String group, String version) {
        this.group = group;
        this.version = version;
    }

    @Override
    public ServiceVersionCondition combine(ServiceVersionCondition other) {
        return this;
    }

    @Override
    public ServiceVersionCondition match(HttpRequest request) {
        String group = request.header(TripleHeaderEnum.SERVICE_GROUP.name());
        if (group == null) {
            group = request.header("rest-service-group");
        }
        if (group != null && !group.equals(this.group)) {
            return null;
        }
        String version = request.header(TripleHeaderEnum.SERVICE_VERSION.name());
        if (version == null) {
            version = request.header("rest-service-version");
        }
        if (version != null && !version.equals(this.version)) {
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(ServiceVersionCondition other, HttpRequest request) {
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.group, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ServiceVersionCondition.class) {
            return false;
        }
        ServiceVersionCondition other = (ServiceVersionCondition)obj;
        return Objects.equals(this.group, other.group) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return "ServiceVersionCondition{group='" + this.group + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

