/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;

public abstract class AnnotationSupport {
    private static final AnnotationMeta[] EMPTY = new AnnotationMeta[0];
    private static final Integer GET_KEY = 1;
    private static final Integer GET_MERGED_KEY = 2;
    private static final Integer FIND_KEY = 3;
    private static final Integer FIND_MERGED_KEY = 4;
    private final Map<Pair<Class, Integer>, Optional<AnnotationMeta>> cache = CollectionUtils.newConcurrentHashMap();
    private final Map<Integer, AnnotationMeta[]> arrayCache = CollectionUtils.newConcurrentHashMap();
    private final RestToolKit toolKit;

    protected AnnotationSupport(RestToolKit toolKit) {
        this.toolKit = toolKit;
    }

    public final AnnotationMeta[] getAnnotations() {
        return this.arrayCache.computeIfAbsent(GET_KEY, k -> {
            AnnotatedElement element = this.getAnnotatedElement();
            Annotation[] annotations = element.getAnnotations();
            int len = annotations.length;
            if (len == 0) {
                return EMPTY;
            }
            AnnotationMeta[] metas = new AnnotationMeta[len];
            for (int i = 0; i < len; ++i) {
                metas[i] = new AnnotationMeta<Annotation>(element, annotations[i], this.toolKit);
            }
            return metas;
        });
    }

    public final Annotation[] getRealAnnotations() {
        AnnotationMeta[] annotations = this.getAnnotations();
        int len = annotations.length;
        Annotation[] result = new Annotation[len];
        for (int i = 0; i < len; ++i) {
            result[i] = annotations[i].getAnnotation();
        }
        return result;
    }

    public final AnnotationMeta getAnnotation(Class<? extends Annotation> annotationType) {
        return this.cache.computeIfAbsent((Pair<Class, Integer>)Pair.of(annotationType, (Object)GET_KEY), k -> {
            AnnotatedElement element = this.getAnnotatedElement();
            Object annotation = element.getAnnotation(annotationType);
            if (annotation != null) {
                return Optional.of(new AnnotationMeta(element, annotation, this.toolKit));
            }
            return Optional.empty();
        }).orElse(null);
    }

    public final AnnotationMeta getAnnotation(AnnotationEnum annotationEnum) {
        return annotationEnum.isPresent() ? this.getAnnotation(annotationEnum.type()) : null;
    }

    public final boolean isAnnotated(Class<Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public final boolean isAnnotated(AnnotationEnum annotationEnum) {
        return this.getAnnotation(annotationEnum) != null;
    }

    public final AnnotationMeta getMergedAnnotation(Class<Annotation> annotationType) {
        return this.cache.computeIfAbsent((Pair<Class, Integer>)Pair.of(annotationType, (Object)GET_MERGED_KEY), k -> {
            Annotation[] annotations;
            AnnotatedElement element = this.getAnnotatedElement();
            for (Annotation annotation : annotations = element.getAnnotations()) {
                if (annotation.annotationType() == annotationType) {
                    return Optional.of(new AnnotationMeta<Annotation>(element, annotation, this.toolKit));
                }
                Object metaAnnotation = annotation.annotationType().getAnnotation(annotationType);
                if (metaAnnotation == null) continue;
                return Optional.of(new AnnotationMeta(element, metaAnnotation, this.toolKit));
            }
            return Optional.empty();
        }).orElse(null);
    }

    public final AnnotationMeta getMergedAnnotation(AnnotationEnum annotationEnum) {
        return annotationEnum.isPresent() ? this.getMergedAnnotation(annotationEnum.type()) : null;
    }

    public final boolean isMergedAnnotated(Class<Annotation> annotationType) {
        return this.getMergedAnnotation(annotationType) != null;
    }

    public final boolean isMergedAnnotated(AnnotationEnum annotationEnum) {
        return this.getMergedAnnotation(annotationEnum) != null;
    }

    public final AnnotationMeta[] findAnnotations() {
        return this.arrayCache.computeIfAbsent(FIND_KEY, k -> {
            List<? extends AnnotatedElement> elements = this.getAnnotatedElements();
            ArrayList<AnnotationMeta<Annotation>> metas = new ArrayList<AnnotationMeta<Annotation>>();
            int len = elements.size();
            for (int i = 0; i < len; ++i) {
                Annotation[] annotations;
                AnnotatedElement element = elements.get(i);
                for (Annotation annotation : annotations = element.getAnnotations()) {
                    metas.add(new AnnotationMeta<Annotation>(element, annotation, this.toolKit));
                }
            }
            if (metas.isEmpty()) {
                return EMPTY;
            }
            return metas.toArray(new AnnotationMeta[0]);
        });
    }

    public final AnnotationMeta findAnnotation(Class<Annotation> annotationType) {
        return this.cache.computeIfAbsent((Pair<Class, Integer>)Pair.of(annotationType, (Object)FIND_KEY), k -> {
            List<? extends AnnotatedElement> elements = this.getAnnotatedElements();
            int len = elements.size();
            for (int i = 0; i < len; ++i) {
                AnnotatedElement element = elements.get(i);
                Object annotation = element.getDeclaredAnnotation(annotationType);
                if (annotation == null) continue;
                return Optional.of(new AnnotationMeta(element, annotation, this.toolKit));
            }
            return Optional.empty();
        }).orElse(null);
    }

    public final AnnotationMeta findAnnotation(AnnotationEnum annotationEnum) {
        return annotationEnum.isPresent() ? this.findAnnotation(annotationEnum.type()) : null;
    }

    public final boolean isHierarchyAnnotated(Class<Annotation> annotationType) {
        return this.getMergedAnnotation(annotationType) != null;
    }

    public final boolean isHierarchyAnnotated(AnnotationEnum annotationEnum) {
        return this.getMergedAnnotation(annotationEnum) != null;
    }

    public final AnnotationMeta findMergedAnnotation(Class<Annotation> annotationType) {
        return this.cache.computeIfAbsent((Pair<Class, Integer>)Pair.of(annotationType, (Object)FIND_MERGED_KEY), k -> {
            List<? extends AnnotatedElement> elements = this.getAnnotatedElements();
            int len = elements.size();
            for (int i = 0; i < len; ++i) {
                Annotation[] annotations;
                AnnotatedElement element = elements.get(i);
                for (Annotation annotation : annotations = element.getDeclaredAnnotations()) {
                    if (annotation.annotationType() == annotationType) {
                        return Optional.of(new AnnotationMeta<Annotation>(element, annotation, this.toolKit));
                    }
                    Object metaAnnotation = annotation.annotationType().getAnnotation(annotationType);
                    if (metaAnnotation == null) continue;
                    return Optional.of(new AnnotationMeta(element, metaAnnotation, this.toolKit));
                }
            }
            return Optional.empty();
        }).orElse(null);
    }

    public final AnnotationMeta findMergedAnnotation(AnnotationEnum annotationEnum) {
        return annotationEnum.isPresent() ? this.findMergedAnnotation(annotationEnum.type()) : null;
    }

    public final boolean isMergedHierarchyAnnotated(Class<Annotation> annotationType) {
        return this.findMergedAnnotation(annotationType) != null;
    }

    public final boolean isMergedHierarchyAnnotated(AnnotationEnum annotationEnum) {
        return this.findMergedAnnotation(annotationEnum) != null;
    }

    public final RestToolKit getToolKit() {
        return this.toolKit;
    }

    protected List<? extends AnnotatedElement> getAnnotatedElements() {
        return Collections.singletonList(this.getAnnotatedElement());
    }

    protected abstract AnnotatedElement getAnnotatedElement();
}

