/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationSupport;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;

public final class MethodMeta
extends AnnotationSupport {
    private final List<Method> hierarchy;
    private final Method method;
    private final ParameterMeta[] parameters;
    private final ServiceMeta serviceMeta;

    public MethodMeta(List<Method> hierarchy, ServiceMeta serviceMeta) {
        super(serviceMeta.getToolKit());
        this.hierarchy = hierarchy;
        this.method = hierarchy.get(0);
        this.parameters = this.initParameters(this.method, hierarchy);
        this.serviceMeta = serviceMeta;
    }

    private ParameterMeta[] initParameters(Method method, List<Method> hierarchy) {
        int count = method.getParameterCount();
        ArrayList parameterHierarchies = new ArrayList(count);
        int len = hierarchy.size();
        for (int i = 0; i < len; ++i) {
            Method m = hierarchy.get(i);
            Parameter[] mps = m.getParameters();
            for (int j = 0; j < count; ++j) {
                List<Parameter> parameterHierarchy;
                if (parameterHierarchies.size() <= j) {
                    parameterHierarchy = new ArrayList(len);
                    parameterHierarchies.add(parameterHierarchy);
                } else {
                    parameterHierarchy = (List)parameterHierarchies.get(j);
                }
                parameterHierarchy.add(mps[j]);
            }
        }
        String[] parameterNames = this.getToolKit().getParameterNames(method);
        ParameterMeta[] parameters = new ParameterMeta[count];
        for (int i = 0; i < count; ++i) {
            String parameterName = parameterNames == null ? null : parameterNames[i];
            parameters[i] = new MethodParameterMeta((List)parameterHierarchies.get(i), parameterName, i, this);
        }
        return parameters;
    }

    public List<Method> getHierarchy() {
        return this.hierarchy;
    }

    public Method getMethod() {
        return this.method;
    }

    public ParameterMeta[] getParameters() {
        return this.parameters;
    }

    public ServiceMeta getServiceMeta() {
        return this.serviceMeta;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    @Override
    protected List<? extends AnnotatedElement> getAnnotatedElements() {
        return this.hierarchy;
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.method;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != MethodMeta.class) {
            return false;
        }
        return this.method.equals(((MethodMeta)obj).method);
    }

    public String toString() {
        return "MethodMeta{method=" + this.method + '}';
    }
}

