/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationSupport;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public abstract class ParameterMeta
extends AnnotationSupport {
    private final String prefix;
    private final String name;
    private Boolean simple;
    private Class<?> actualType;
    private Object typeDescriptor;

    protected ParameterMeta(RestToolKit toolKit, String prefix, String name) {
        super(toolKit);
        this.prefix = StringUtils.isEmpty((String)prefix) ? null : prefix;
        this.name = name;
    }

    protected ParameterMeta(RestToolKit toolKit, String name) {
        super(toolKit);
        this.prefix = null;
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final String getRequiredName() {
        if (this.name == null) {
            throw new RestException(Messages.ARGUMENT_NAME_MISSING, this.getType());
        }
        return this.name;
    }

    public final boolean isSimple() {
        Boolean simple = this.simple;
        if (simple == null) {
            this.simple = simple = Boolean.valueOf(TypeUtils.isSimpleProperty(this.getActualType()));
        }
        return simple;
    }

    public final Class<?> getActualType() {
        Class<Object> type = this.actualType;
        if (type == null) {
            type = this.getType();
            if (type == Optional.class && (type = TypeUtils.getNestedType(this.getGenericType(), 0)) == null) {
                type = Object.class;
            }
            this.actualType = type;
        }
        return type;
    }

    public final Object getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public final void setTypeDescriptor(Object typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
    }

    public final Object bind(HttpRequest request, HttpResponse response) {
        return this.getToolKit().bind(this, request, response);
    }

    public String getDescription() {
        return this.name;
    }

    public abstract Class<?> getType();

    public abstract Type getGenericType();

    public String toString() {
        return "ParameterMeta{name='" + this.name + "', type=" + this.getType() + '}';
    }
}

