/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.service;

import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SchemaDescriptorRegistry {
    private static final Map<String, Descriptors.FileDescriptor> DESCRIPTORS_BY_SYMBOL = new ConcurrentHashMap<String, Descriptors.FileDescriptor>();
    private static final Map<String, Map<Integer, Descriptors.FileDescriptor>> EXTENSIONS = new ConcurrentHashMap<String, Map<Integer, Descriptors.FileDescriptor>>();
    private static final Set<String> SERVICES = new HashSet<String>();

    public static void addSchemaDescriptor(String serviceName, Descriptors.FileDescriptor fd) {
        SERVICES.add(serviceName);
        DESCRIPTORS_BY_SYMBOL.put(serviceName, fd);
        for (Descriptors.Descriptor messageType : fd.getMessageTypes()) {
            SchemaDescriptorRegistry.addType(messageType);
        }
        for (Descriptors.FieldDescriptor extension : fd.getExtensions()) {
            SchemaDescriptorRegistry.addExtension(extension, fd);
        }
    }

    private static void addType(Descriptors.Descriptor descriptor) {
        DESCRIPTORS_BY_SYMBOL.put(descriptor.getFullName(), descriptor.getFile());
        for (Descriptors.Descriptor nestedType : descriptor.getNestedTypes()) {
            SchemaDescriptorRegistry.addType(nestedType);
        }
    }

    private static void addExtension(Descriptors.FieldDescriptor extension, Descriptors.FileDescriptor fd) {
        String name = extension.getContainingType().getFullName();
        int number = extension.getNumber();
        if (!EXTENSIONS.containsKey(name)) {
            EXTENSIONS.put(name, new HashMap());
        }
        Map<Integer, Descriptors.FileDescriptor> fdMap = EXTENSIONS.get(name);
        fdMap.put(number, fd);
    }

    public static Descriptors.FileDescriptor getFileDescriptorByExtensionAndNumber(String extension, int number) {
        return (Descriptors.FileDescriptor)EXTENSIONS.getOrDefault(extension, Collections.emptyMap()).get(number);
    }

    public static Set<Integer> getExtensionNumbers(String extension) {
        Map<Integer, Descriptors.FileDescriptor> ret = EXTENSIONS.get(extension);
        if (ret == null) {
            return null;
        }
        return ret.keySet();
    }

    public static Descriptors.FileDescriptor getSchemaDescriptor(String serviceName) {
        return DESCRIPTORS_BY_SYMBOL.get(serviceName);
    }

    public static List<String> listServiceNames() {
        return new ArrayList<String>(SERVICES);
    }
}

