/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.protocol.tri.ThrowableWrapper;

public class ExceptionUtils {
    private static final int NOT_FOUND = -1;

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String getStackFrameString(List<String> stackFrameList) {
        if (CollectionUtils.isEmpty(stackFrameList)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : stackFrameList) {
            stringBuilder.append(s).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String[] getStackFrames(Throwable throwable) {
        if (throwable == null) {
            return new String[0];
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable));
    }

    static String[] getStackFrames(String stackTrace) {
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public static List<String> getStackFrameList(Throwable t, int maxDepth) {
        String stackTrace = ExceptionUtils.getStackTrace(t);
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < maxDepth && frames.hasMoreTokens(); ++i) {
            list.add(frames.nextToken());
        }
        return list;
    }

    public static List<String> getStackFrameList(Throwable t) {
        return ExceptionUtils.getStackFrameList(t, Integer.MAX_VALUE);
    }

    public static RuntimeException wrap(Throwable t) {
        while (true) {
            Throwable cause;
            if (t instanceof UndeclaredThrowableException) {
                t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
                continue;
            }
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
                continue;
            }
            if (!(t instanceof CompletionException) && !(t instanceof ExecutionException) || (cause = t.getCause()) == t) break;
            t = cause;
        }
        return t instanceof RuntimeException ? (RuntimeException)t : new ThrowableWrapper(t);
    }

    public static Throwable unwrap(Throwable t) {
        while (true) {
            Throwable cause;
            if (t instanceof ThrowableWrapper) {
                t = ((ThrowableWrapper)t).getOriginal();
                continue;
            }
            if (t instanceof UndeclaredThrowableException) {
                t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
                continue;
            }
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
                continue;
            }
            if (!(t instanceof CompletionException) && !(t instanceof ExecutionException) || (cause = t.getCause()) == t) break;
            t = cause;
        }
        return t;
    }

    public static String buildVerboseMessage(Throwable t) {
        Throwable parent;
        StringBuilder sb = new StringBuilder(256);
        t = ExceptionUtils.unwrap(t);
        String before = null;
        do {
            String msg = t.getMessage();
            String className = t.getClass().getName();
            if (before != null) {
                if (!before.startsWith(className) && !before.equals(msg)) {
                    sb.append(": ").append(before);
                }
                sb.append(" -> ");
            }
            sb.append(className);
            before = msg;
            parent = t;
        } while ((t = t.getCause()) != null && t != parent);
        if (before != null) {
            sb.append(": ").append(before);
        }
        sb.append("\n -> Stack traces:");
        StackTraceElement[] elements = parent.getStackTrace();
        int len = elements.length;
        for (int i = 0; i < 10 && i < len; ++i) {
            sb.append("\n    at ").append(elements[i]);
        }
        return sb.toString();
    }
}

