/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import java.util.Map;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.PackableMethod;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;

public class RequestMetadata {
    public AsciiString scheme;
    public String application;
    public String service;
    public String version;
    public String group;
    public String address;
    public String acceptEncoding;
    public String timeout;
    public Compressor compressor;
    public CancellationContext cancellationContext;
    public MethodDescriptor method;
    public PackableMethod packableMethod;
    public Map<String, Object> attachments;
    public boolean convertNoLowerHeader;
    public boolean ignoreDefaultVersion;

    public DefaultHttp2Headers toHeaders() {
        DefaultHttp2Headers header = new DefaultHttp2Headers(false);
        ((Http2Headers)header.scheme((CharSequence)this.scheme).authority((CharSequence)this.address).method((CharSequence)HttpMethod.POST.asciiName()).path((CharSequence)("/" + this.service + "/" + this.method.getMethodName())).set((Object)TripleHeaderEnum.CONTENT_TYPE_KEY.getHeader(), (Object)MediaType.APPLICATION_GRPC_PROTO.getName())).set((Object)HttpHeaderNames.TE, (Object)HttpHeaderValues.TRAILERS);
        this.setIfNotNull(header, TripleHeaderEnum.TIMEOUT.getHeader(), this.timeout);
        if (!this.ignoreDefaultVersion || !"1.0.0".equals(this.version)) {
            this.setIfNotNull(header, TripleHeaderEnum.SERVICE_VERSION.getHeader(), this.version);
        }
        this.setIfNotNull(header, TripleHeaderEnum.SERVICE_GROUP.getHeader(), this.group);
        this.setIfNotNull(header, TripleHeaderEnum.CONSUMER_APP_NAME_KEY.getHeader(), this.application);
        this.setIfNotNull(header, TripleHeaderEnum.GRPC_ACCEPT_ENCODING.getHeader(), this.acceptEncoding);
        if (!"identity".equals(this.compressor.getMessageEncoding())) {
            this.setIfNotNull(header, TripleHeaderEnum.GRPC_ENCODING.getHeader(), this.compressor.getMessageEncoding());
        }
        StreamUtils.putHeaders(header, this.attachments, this.convertNoLowerHeader);
        return header;
    }

    private void setIfNotNull(DefaultHttp2Headers headers, CharSequence key, CharSequence value) {
        if (value == null) {
            return;
        }
        headers.set((Object)key, (Object)value);
    }
}

