/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.handler.codec.http2.Http2Headers;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;

public enum TripleHeaderEnum {
    AUTHORITY_KEY(":authority"),
    PATH_KEY(":path"),
    HTTP_STATUS_KEY("http-status"),
    STATUS_KEY("grpc-status"),
    MESSAGE_KEY("grpc-message"),
    STATUS_DETAIL_KEY("grpc-status-details-bin"),
    TIMEOUT("grpc-timeout"),
    CONTENT_TYPE_KEY("content-type"),
    CONTENT_PROTO("application/grpc+proto"),
    APPLICATION_GRPC("application/grpc"),
    GRPC_ENCODING("grpc-encoding"),
    GRPC_ACCEPT_ENCODING("grpc-accept-encoding"),
    CONSUMER_APP_NAME_KEY("tri-consumer-appname"),
    SERVICE_VERSION("tri-service-version"),
    SERVICE_GROUP("tri-service-group"),
    SERVICE_TIMEOUT("tri-service-timeout"),
    TRI_HEADER_CONVERT("tri-header-convert"),
    TRI_EXCEPTION_CODE("tri-exception-code");

    static final Map<String, TripleHeaderEnum> enumMap;
    static final Set<String> excludeAttachmentsSet;
    private final String header;

    private TripleHeaderEnum(String header) {
        this.header = header;
    }

    public static boolean containsExcludeAttachments(String key) {
        return excludeAttachmentsSet.contains(key) || enumMap.containsKey(key);
    }

    public String getHeader() {
        return this.header;
    }

    static {
        enumMap = new HashMap<String, TripleHeaderEnum>();
        excludeAttachmentsSet = new HashSet<String>();
        for (TripleHeaderEnum tripleHeaderEnum : TripleHeaderEnum.values()) {
            enumMap.put(tripleHeaderEnum.getHeader(), tripleHeaderEnum);
        }
        for (TripleHeaderEnum tripleHeaderEnum : Http2Headers.PseudoHeaderName.values()) {
            excludeAttachmentsSet.add(tripleHeaderEnum.value().toString());
        }
        String[] internalHttpHeaders = new String[]{"group", "interface", "path", "remote.application", "application", "serialization", "rest-service-version", "rest-service-group"};
        Collections.addAll(excludeAttachmentsSet, internalHttpHeaders);
        String[] excludeStandardHttpHeaders = TripleProtocol.PASS_THROUGH_STANDARD_HTTP_HEADERS ? new String[]{"accept", "accept-charset", "accept-encoding", "accept-language", "cache-control", "connection", "content-length", "content-md5", "content-type", "host"} : new String[]{"accept", "accept-charset", "accept-datetime", "accept-encoding", "accept-language", "access-control-request-headers", "access-control-request-method", "authorization", "cache-control", "connection", "content-length", "content-md5", "content-type", "cookie", "date", "dnt", "expect", "forwarded", "from", "host", "http2-settings", "if-match", "if-modified-since", "if-none-match", "if-range", "if-unmodified-since", "max-forwards", "origin", "pragma", "proxy-authorization", "range", "referer", "sec-fetch-dest", "sec-fetch-mode", "sec-fetch-site", "sec-fetch-user", "te", "trailer", "upgrade", "upgrade-insecure-requests", "user-agent", "x-csrf-token", "x-forwarded-for", "x-forwarded-host", "x-forwarded-proto", "x-http-method-override", "x-real-ip", "x-request-id", "x-requested-with"};
        Collections.addAll(excludeAttachmentsSet, excludeStandardHttpHeaders);
    }
}

