/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.RequestMetadata;
import org.apache.dubbo.rpc.protocol.tri.call.ClientCall;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;
import org.apache.dubbo.rpc.protocol.tri.observer.ClientCallToObserverAdapter;
import org.apache.dubbo.rpc.protocol.tri.stream.ClientStream;
import org.apache.dubbo.rpc.protocol.tri.stream.ClientStreamFactory;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleWriteQueue;

public class TripleClientCall
implements ClientCall,
ClientStream.Listener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(TripleClientCall.class);
    private final AbstractConnectionClient connectionClient;
    private final Executor executor;
    private final FrameworkModel frameworkModel;
    private final TripleWriteQueue writeQueue;
    private RequestMetadata requestMetadata;
    private ClientStream stream;
    private ClientCall.Listener listener;
    private boolean canceled;
    private boolean headerSent;
    private boolean autoRequest = true;
    private boolean done;
    private Http2Exception.StreamException streamException;

    public TripleClientCall(AbstractConnectionClient connectionClient, Executor executor, FrameworkModel frameworkModel, TripleWriteQueue writeQueue) {
        this.connectionClient = connectionClient;
        this.executor = executor;
        this.frameworkModel = frameworkModel;
        this.writeQueue = writeQueue;
    }

    @Override
    public void onMessage(byte[] message, boolean isReturnTriException) {
        if (this.done) {
            LOGGER.warn("4-15", "", "", "Received message from closed stream,connection=" + this.connectionClient + " service=" + this.requestMetadata.service + " method=" + this.requestMetadata.method.getMethodName());
            return;
        }
        try {
            Object unpacked = this.requestMetadata.packableMethod.parseResponse(message, isReturnTriException);
            this.listener.onMessage(unpacked, message.length);
        }
        catch (Throwable t) {
            TriRpcStatus status = TriRpcStatus.INTERNAL.withDescription("Deserialize response failed").withCause(t);
            this.cancelByLocal((Throwable)((Object)status.asException()));
            this.listener.onClose(status, null, false);
            LOGGER.error("4-14", "", "", String.format("Failed to deserialize triple response, service=%s, method=%s,connection=%s", this.connectionClient, this.requestMetadata.service, this.requestMetadata.method.getMethodName()), t);
        }
    }

    @Override
    public void onCancelByRemote(TriRpcStatus status) {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        if (this.requestMetadata.cancellationContext != null) {
            this.requestMetadata.cancellationContext.cancel((Throwable)((Object)status.asException()));
        }
        this.onComplete(status, null, null, false);
    }

    @Override
    public void onComplete(TriRpcStatus status, Map<String, Object> attachments, Map<String, String> excludeHeaders, boolean isReturnTriException) {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.listener.onClose(status, StreamUtils.toAttachments(attachments), isReturnTriException);
        }
        catch (Throwable t) {
            this.cancelByLocal((Throwable)((Object)TriRpcStatus.INTERNAL.withDescription("Close stream error").withCause(t).asException()));
        }
        if (this.requestMetadata.cancellationContext != null) {
            this.requestMetadata.cancellationContext.cancel(null);
        }
    }

    @Override
    public void onStart() {
        this.listener.onStart(this);
    }

    @Override
    public void cancelByLocal(Throwable t) {
        TriRpcStatus status;
        if (this.canceled) {
            return;
        }
        if (!this.headerSent) {
            return;
        }
        this.canceled = true;
        if (this.stream == null) {
            return;
        }
        if (t instanceof Http2Exception.StreamException && ((Http2Exception.StreamException)t).error().equals((Object)Http2Error.FLOW_CONTROL_ERROR)) {
            status = TriRpcStatus.CANCELLED.withCause(t).withDescription("Due flowcontrol over pendingbytes, Cancelled by client");
            this.stream.cancelByLocal(status);
            this.streamException = (Http2Exception.StreamException)t;
        } else {
            status = TriRpcStatus.CANCELLED.withCause(t).withDescription("Cancelled by client");
            this.stream.cancelByLocal(status);
        }
        status = TriRpcStatus.CANCELLED.withCause(t).withDescription("Cancelled by client");
        this.stream.cancelByLocal(status);
        if (this.requestMetadata.cancellationContext != null) {
            this.requestMetadata.cancellationContext.cancel(t);
        }
    }

    @Override
    public void request(int messageNumber) {
        this.stream.request(messageNumber);
    }

    @Override
    public void sendMessage(Object message) {
        if (this.canceled && null != this.streamException) {
            throw new IllegalStateException("Due flowcontrol over pendingbytes, Call already canceled");
        }
        if (this.canceled) {
            throw new IllegalStateException("Call already canceled");
        }
        if (!this.headerSent) {
            this.headerSent = true;
            this.stream.sendHeader((Http2Headers)this.requestMetadata.toHeaders());
        }
        try {
            byte[] data = this.requestMetadata.packableMethod.packRequest(message);
            int compressed = "identity".equals(this.requestMetadata.compressor.getMessageEncoding()) ? 0 : 1;
            byte[] compress = this.requestMetadata.compressor.compress(data);
            this.stream.sendMessage(compress, compressed, false).addListener(f -> {
                if (!f.isSuccess()) {
                    this.cancelByLocal(f.cause());
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error("4-10", "", "", String.format("Serialize triple request failed, service=%s method=%s", this.requestMetadata.service, this.requestMetadata.method.getMethodName()), t);
            this.cancelByLocal(t);
            this.listener.onClose(TriRpcStatus.INTERNAL.withDescription("Serialize request failed").withCause(t), null, false);
        }
    }

    @Override
    public void halfClose() {
        if (!this.headerSent) {
            return;
        }
        if (this.canceled) {
            return;
        }
        this.stream.halfClose().addListener(f -> {
            if (!f.isSuccess()) {
                this.cancelByLocal(new IllegalStateException("Half close failed", f.cause()));
            }
        });
    }

    @Override
    public void setCompression(String compression) {
        this.requestMetadata.compressor = Compressor.getCompressor(this.frameworkModel, compression);
    }

    @Override
    public StreamObserver<Object> start(RequestMetadata metadata, ClientCall.Listener responseListener) {
        for (ClientStreamFactory factory : this.frameworkModel.getActivateExtensions(ClientStreamFactory.class)) {
            ClientStream stream = factory.createClientStream(this.connectionClient, this.frameworkModel, this.executor, this, this.writeQueue);
            if (stream == null) continue;
            this.requestMetadata = metadata;
            this.listener = responseListener;
            this.stream = stream;
            return new ClientCallToObserverAdapter<Object>(this);
        }
        throw new IllegalStateException("No available ClientStreamFactory");
    }

    @Override
    public boolean isAutoRequest() {
        return this.autoRequest;
    }

    @Override
    public void setAutoRequest(boolean autoRequest) {
        this.autoRequest = autoRequest;
    }
}

