/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.remoting.http12.ExceptionHandler;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpInputMessage;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.HttpTransportListener;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.DescriptorUtils;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.RpcInvocationBuildContext;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.CompositeExceptionHandler;
import org.apache.dubbo.rpc.protocol.tri.route.DefaultRequestRouter;
import org.apache.dubbo.rpc.protocol.tri.route.RequestRouter;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;

public abstract class AbstractServerTransportListener<HEADER extends RequestMetadata, MESSAGE extends HttpInputMessage>
implements HttpTransportListener<HEADER, MESSAGE> {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(AbstractServerTransportListener.class);
    private final FrameworkModel frameworkModel;
    private final URL url;
    private final HttpChannel httpChannel;
    private final RequestRouter requestRouter;
    private final ExceptionHandler<Throwable, ?> exceptionHandler;
    private final List<HeaderFilter> headerFilters;
    private Executor executor;
    private HEADER httpMetadata;
    private RpcInvocationBuildContext context;
    private HttpMessageListener httpMessageListener;

    protected AbstractServerTransportListener(FrameworkModel frameworkModel, URL url, HttpChannel httpChannel) {
        this.frameworkModel = frameworkModel;
        this.url = url;
        this.httpChannel = httpChannel;
        this.requestRouter = (RequestRouter)frameworkModel.getBeanFactory().getOrRegisterBean(DefaultRequestRouter.class);
        this.exceptionHandler = (ExceptionHandler)frameworkModel.getBeanFactory().getOrRegisterBean(CompositeExceptionHandler.class);
        this.headerFilters = frameworkModel.getExtensionLoader(HeaderFilter.class).getActivateExtension(url, "header.filter");
    }

    public void onMetadata(HEADER metadata) {
        try {
            this.executor = this.initializeExecutor(metadata);
        }
        catch (Throwable throwable) {
            LOGGER.error("0-18", "", "", "initialize executor fail.", throwable);
            this.onError(throwable);
            return;
        }
        if (this.executor == null) {
            LOGGER.error("99-0", "", "", "executor must be not null.");
            this.onError(new NullPointerException("initializeExecutor return null"));
            return;
        }
        this.executor.execute(() -> {
            try {
                this.doOnMetadata(metadata);
            }
            catch (Throwable t) {
                this.logError(t);
                this.onError(t);
            }
        });
    }

    protected Executor initializeExecutor(HEADER metadata) {
        return Runnable::run;
    }

    protected void doOnMetadata(HEADER metadata) {
        this.onPrepareMetadata(metadata);
        this.httpMetadata = metadata;
        this.context = this.requestRouter.route(this.url, (RequestMetadata)metadata, this.httpChannel);
        if (this.context == null) {
            throw new HttpStatusException(HttpStatus.NOT_FOUND.getCode(), "Invoker not found");
        }
        this.setHttpMessageListener(this.buildHttpMessageListener());
        this.onMetadataCompletion(metadata);
    }

    protected abstract HttpMessageListener buildHttpMessageListener();

    public void onData(MESSAGE message) {
        this.executor.execute(() -> {
            try {
                this.doOnData(message);
            }
            catch (Throwable t) {
                this.logError(t);
                this.onError(message, t);
            }
            finally {
                this.onFinally(message);
            }
        });
    }

    protected void doOnData(MESSAGE message) {
        if (this.httpMessageListener == null) {
            return;
        }
        this.onPrepareData(message);
        this.httpMessageListener.onMessage(message.getBody());
        this.onDataCompletion(message);
    }

    protected void onPrepareMetadata(HEADER header) {
    }

    protected void onMetadataCompletion(HEADER metadata) {
    }

    protected void onPrepareData(MESSAGE message) {
    }

    protected void onDataCompletion(MESSAGE message) {
    }

    protected void logError(Throwable t) {
        t = ExceptionUtils.unwrap(t);
        Supplier<String> msg = () -> {
            StringBuilder sb = new StringBuilder(64);
            sb.append("An error occurred while processing the http request, ");
            sb.append(this.httpMetadata);
            if (TripleProtocol.VERBOSE_ENABLED) {
                sb.append(", headers=").append(this.httpMetadata.headers());
            }
            if (this.context != null) {
                Invoker<?> invoker;
                MethodDescriptor md = this.context.getMethodDescriptor();
                if (md != null) {
                    sb.append(", method=").append(MethodUtils.toShortString((Method)md.getMethod()));
                }
                if (TripleProtocol.VERBOSE_ENABLED && (invoker = this.context.getInvoker()) != null) {
                    URL url = invoker.getUrl();
                    Object service = url.getServiceModel().getProxyObject();
                    sb.append(", service=").append(service.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(service))).append(", url='").append(url).append('\'');
                }
            }
            return sb.toString();
        };
        switch (this.exceptionHandler.resolveLogLevel(t)) {
            case TRACE: {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(msg.get(), t);
                }
                return;
            }
            case DEBUG: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(msg.get(), t);
                }
                return;
            }
            case INFO: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(msg.get(), t);
                }
                return;
            }
            case WARN: {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("99-0", "", "", msg.get(), t);
                }
                return;
            }
            case ERROR: {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("99-0", "", "", msg.get(), t);
                }
                return;
            }
        }
    }

    protected void onError(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof InvocationTargetException) {
            Throwable targetException = ((InvocationTargetException)throwable).getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
        }
        throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR.getCode(), throwable);
    }

    protected void onError(MESSAGE message, Throwable throwable) {
        this.onError(throwable);
    }

    protected void onFinally(MESSAGE message) {
        try {
            message.close();
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    protected RpcInvocation buildRpcInvocation(RpcInvocationBuildContext context) {
        MethodMetadata methodMetadata;
        MethodDescriptor methodDescriptor = context.getMethodDescriptor();
        if (methodDescriptor == null) {
            methodDescriptor = DescriptorUtils.findMethodDescriptor(context.getServiceDescriptor(), context.getMethodName(), context.isHasStub());
            context.setMethodDescriptor(methodDescriptor);
            this.onSettingMethodDescriptor(methodDescriptor);
        }
        if ((methodMetadata = context.getMethodMetadata()) == null) {
            methodMetadata = MethodMetadata.fromMethodDescriptor((MethodDescriptor)methodDescriptor);
            context.setMethodMetadata(methodMetadata);
        }
        Invoker<?> invoker = context.getInvoker();
        URL url = invoker.getUrl();
        RpcInvocation inv = new RpcInvocation(url.getServiceModel(), methodDescriptor.getMethodName(), context.getServiceDescriptor().getInterfaceName(), url.getProtocolServiceKey(), methodDescriptor.getParameterClasses(), new Object[0]);
        inv.setTargetServiceUniqueName(url.getServiceKey());
        inv.setReturnTypes(methodDescriptor.getReturnTypes());
        inv.setObjectAttachments(StreamUtils.toAttachments(this.httpMetadata.headers()));
        inv.put((Object)"tri.remote.address", (Object)this.httpChannel.remoteAddress());
        inv.getAttributes().putAll(context.getAttributes());
        String consumerAppName = this.httpMetadata.headers().getFirst(TripleHeaderEnum.CONSUMER_APP_NAME_KEY.getHeader());
        if (null != consumerAppName) {
            inv.put((Object)TripleHeaderEnum.CONSUMER_APP_NAME_KEY, (Object)consumerAppName);
        }
        this.headerFilters.forEach(f -> f.invoke(invoker, inv));
        this.initializeAltSvc(url);
        return this.onBuildRpcInvocationCompletion(inv);
    }

    protected void initializeAltSvc(URL url) {
    }

    protected RpcInvocation onBuildRpcInvocationCompletion(RpcInvocation invocation) {
        String timeoutString = this.httpMetadata.headers().getFirst(TripleHeaderEnum.SERVICE_TIMEOUT.getHeader());
        try {
            if (null != timeoutString) {
                Long timeout = Long.parseLong(timeoutString);
                invocation.put((Object)"timeout", (Object)timeout);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("4-9", "", "", String.format("Failed to parse request timeout set from:%s, service=%s method=%s", timeoutString, this.context.getServiceDescriptor().getInterfaceName(), this.context.getMethodName()));
        }
        return invocation;
    }

    protected final FrameworkModel getFrameworkModel() {
        return this.frameworkModel;
    }

    protected ExceptionHandler<Throwable, ?> getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected final HEADER getHttpMetadata() {
        return this.httpMetadata;
    }

    public final RpcInvocationBuildContext getContext() {
        return this.context;
    }

    protected final HttpMessageListener getHttpMessageListener() {
        return this.httpMessageListener;
    }

    protected final void setHttpMessageListener(HttpMessageListener httpMessageListener) {
        this.httpMessageListener = httpMessageListener;
    }

    protected void onSettingMethodDescriptor(MethodDescriptor methodDescriptor) {
    }
}

