/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.h12.AbstractServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerCallToObserverAdapter;

public class UnaryServerCallListener
extends AbstractServerCallListener {
    private final boolean applyCustomizeException;

    public UnaryServerCallListener(RpcInvocation invocation, Invoker<?> invoker, StreamObserver<Object> responseObserver, boolean applyCustomizeException) {
        super(invocation, invoker, responseObserver);
        this.applyCustomizeException = applyCustomizeException;
    }

    @Override
    public void onReturn(Object value) {
        this.responseObserver.onNext(value);
        this.responseObserver.onCompleted();
    }

    @Override
    public void onMessage(Object message) {
        if (message instanceof Object[]) {
            this.invocation.setArguments((Object[])message);
        } else {
            this.invocation.setArguments(new Object[]{message});
        }
    }

    @Override
    protected void onResponseException(Throwable t) {
        if (this.applyCustomizeException) {
            TriRpcStatus status = TriRpcStatus.getStatus(t);
            int exceptionCode = status.code.code;
            if (exceptionCode == TriRpcStatus.UNKNOWN.code.code) {
                exceptionCode = 3;
            }
            if (this.responseObserver instanceof ServerCallToObserverAdapter) {
                ((ServerCallToObserverAdapter)this.responseObserver).setExceptionCode(exceptionCode);
            }
            this.onReturn(t);
        } else {
            super.onResponseException(t);
        }
    }

    @Override
    public void onCancel(long code) {
    }

    @Override
    public void onComplete() {
        this.invoke();
    }
}

