/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.ExceptionHandler;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.UnimplementedException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2ServerChannelObserver;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.DescriptorUtils;
import org.apache.dubbo.rpc.protocol.tri.ReflectionPackableMethod;
import org.apache.dubbo.rpc.protocol.tri.RpcInvocationBuildContext;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcCompositeCodec;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcHeaderNames;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcServerChannelObserver;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcStreamingDecoder;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcUtils;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.GenericHttp2ServerTransportListener;

public class GrpcHttp2ServerTransportListener
extends GenericHttp2ServerTransportListener
implements Http2TransportListener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(GrpcHttp2ServerTransportListener.class);

    public GrpcHttp2ServerTransportListener(H2StreamChannel h2StreamChannel, URL url, FrameworkModel frameworkModel) {
        super(h2StreamChannel, url, frameworkModel);
        this.getServerChannelObserver().setTrailersCustomizer(this::grpcTrailersCustomize);
    }

    private void grpcTrailersCustomize(HttpHeaders httpHeaders, Throwable throwable) {
        if (throwable == null) {
            httpHeaders.set(GrpcHeaderNames.GRPC_STATUS.getName(), "0");
        } else {
            httpHeaders.set(GrpcHeaderNames.GRPC_STATUS.getName(), GrpcHttp2ServerTransportListener.httpStatusToGrpcStatus(throwable));
            httpHeaders.set(GrpcHeaderNames.GRPC_MESSAGE.getName(), throwable.getMessage());
        }
    }

    private static String httpStatusToGrpcStatus(Throwable throwable) {
        return String.valueOf(TriRpcStatus.INTERNAL.code.code);
    }

    @Override
    protected StreamingDecoder newStreamingDecoder() {
        return new GrpcStreamingDecoder();
    }

    @Override
    protected Http2ServerChannelObserver newHttp2ServerChannelObserver(FrameworkModel frameworkModel, H2StreamChannel h2StreamChannel) {
        return new GrpcServerChannelObserver(frameworkModel, h2StreamChannel);
    }

    @Override
    protected HttpMessageListener buildHttpMessageListener() {
        return this.getContext().isHasStub() ? super.buildHttpMessageListener() : new LazyFindMethodListener();
    }

    @Override
    protected void onUnary() {
    }

    @Override
    protected void onMetadataCompletion(Http2Header metadata) {
        this.processGrpcHeaders(metadata);
        super.onMetadataCompletion(metadata);
    }

    private void processGrpcHeaders(Http2Header metadata) {
        String messageEncoding = metadata.headers().getFirst(GrpcHeaderNames.GRPC_ENCODING.getName());
        if (null != messageEncoding && !"identity".equals(messageEncoding)) {
            DeCompressor compressor = DeCompressor.getCompressor(this.getFrameworkModel(), messageEncoding);
            if (null == compressor) {
                throw new UnimplementedException(GrpcHeaderNames.GRPC_ENCODING.getName() + " '" + messageEncoding + "'");
            }
            this.getStreamingDecoder().setDeCompressor(compressor);
        }
    }

    @Override
    protected RpcInvocation onBuildRpcInvocationCompletion(RpcInvocation invocation) {
        String timeoutString = ((Http2Header)this.getHttpMetadata()).headers().getFirst(GrpcHeaderNames.GRPC_TIMEOUT.getName());
        try {
            if (null != timeoutString) {
                Long timeout = GrpcUtils.parseTimeoutToMills(timeoutString);
                invocation.put((Object)"timeout", (Object)timeout);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("4-9", "", "", String.format("Failed to parse request timeout set from:%s, service=%s method=%s", timeoutString, this.getContext().getServiceDescriptor().getInterfaceName(), this.getContext().getMethodName()));
        }
        return invocation;
    }

    @Override
    protected ExceptionHandler<Throwable, ?> getExceptionHandler() {
        return null;
    }

    protected GrpcStreamingDecoder getStreamingDecoder() {
        return (GrpcStreamingDecoder)super.getStreamingDecoder();
    }

    @Override
    protected boolean applyCustomizeException() {
        RpcInvocationBuildContext context = this.getContext();
        if (context.isHasStub()) {
            return false;
        }
        MethodMetadata methodMetadata = context.getMethodMetadata();
        return ReflectionPackableMethod.needWrap(context.getMethodDescriptor(), methodMetadata.getActualRequestTypes(), methodMetadata.getActualResponseType());
    }

    @Override
    protected void onSettingMethodDescriptor(MethodDescriptor methodDescriptor) {
        GrpcCompositeCodec grpcCompositeCodec = (GrpcCompositeCodec)this.getContext().getHttpMessageDecoder();
        grpcCompositeCodec.loadPackableMethod(methodDescriptor);
        super.onSettingMethodDescriptor(methodDescriptor);
    }

    private class LazyFindMethodListener
    implements HttpMessageListener {
        private final StreamingDecoder streamingDecoder = new GrpcStreamingDecoder();

        private LazyFindMethodListener() {
            this.streamingDecoder.setFragmentListener((StreamingDecoder.FragmentListener)new DetermineMethodDescriptorListener());
            this.streamingDecoder.request(Integer.MAX_VALUE);
        }

        @Override
        public void onMessage(InputStream inputStream) {
            this.streamingDecoder.decode(inputStream);
        }
    }

    private class DetermineMethodDescriptorListener
    implements StreamingDecoder.FragmentListener {
        private DetermineMethodDescriptorListener() {
        }

        public void onClose() {
            GrpcHttp2ServerTransportListener.this.getStreamingDecoder().close();
        }

        public void onFragmentMessage(InputStream rawMessage) {
            try {
                RpcInvocationBuildContext context = GrpcHttp2ServerTransportListener.this.getContext();
                if (null == context.getMethodDescriptor()) {
                    MethodDescriptor methodDescriptor = DescriptorUtils.findTripleMethodDescriptor(context.getServiceDescriptor(), context.getMethodName(), rawMessage);
                    context.setMethodDescriptor(methodDescriptor);
                    GrpcHttp2ServerTransportListener.this.onSettingMethodDescriptor(methodDescriptor);
                    GrpcHttp2ServerTransportListener.this.setHttpMessageListener(GrpcHttp2ServerTransportListener.super.buildHttpMessageListener());
                }
                GrpcHttp2ServerTransportListener.this.getStreamingDecoder().invokeListener(rawMessage);
            }
            catch (IOException e) {
                throw new DecodeException((Throwable)e);
            }
        }
    }
}

