/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.DescriptorUtils;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcCompositeCodecFactory;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandler;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandlerMapping;

@Activate(order=-3000)
public final class GrpcRequestHandlerMapping
implements RequestHandlerMapping {
    public static final GrpcCompositeCodecFactory CODEC_FACTORY = new GrpcCompositeCodecFactory();
    private final FrameworkModel frameworkModel;
    private final PathResolver pathResolver;

    public GrpcRequestHandlerMapping(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.pathResolver = (PathResolver)frameworkModel.getDefaultExtension(PathResolver.class);
    }

    @Override
    public RequestHandler getRequestHandler(URL url, HttpRequest request, HttpResponse response) {
        String contentType = request.contentType();
        if (contentType == null || !contentType.startsWith(MediaType.APPLICATION_GRPC.getName())) {
            return null;
        }
        String uri = request.uri();
        int index = uri.indexOf(47, 1);
        if (index == -1) {
            return null;
        }
        if (uri.indexOf(47, index + 1) != -1) {
            return null;
        }
        String serviceName = uri.substring(1, index);
        String version = request.header(TripleHeaderEnum.SERVICE_VERSION.getHeader());
        String group = request.header(TripleHeaderEnum.SERVICE_GROUP.getHeader());
        String key = URL.buildKey((String)serviceName, (String)group, (String)version);
        Invoker invoker = this.pathResolver.resolve(key);
        if (invoker == null && TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT && (invoker = this.pathResolver.resolve(URL.buildKey((String)serviceName, (String)group, (String)"1.0.0"))) == null && (invoker = this.pathResolver.resolve(serviceName)) == null) {
            return null;
        }
        RequestHandler handler = new RequestHandler(invoker);
        handler.setHasStub(this.pathResolver.hasNativeStub(uri));
        handler.setMethodName(uri.substring(index + 1));
        handler.setServiceDescriptor(DescriptorUtils.findServiceDescriptor(invoker, serviceName, handler.isHasStub()));
        HttpMessageCodec codec = CODEC_FACTORY.createCodec(url, this.frameworkModel, request.contentType());
        handler.setHttpMessageDecoder((HttpMessageDecoder)codec);
        handler.setHttpMessageEncoder((HttpMessageEncoder)codec);
        return handler;
    }

    @Override
    public String getType() {
        return "grpc";
    }
}

