/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http1;

import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.serial.SerializingExecutor;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpInputMessage;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.h1.Http1ServerChannelObserver;
import org.apache.dubbo.remoting.http12.h1.Http1ServerStreamChannelObserver;
import org.apache.dubbo.remoting.http12.h1.Http1ServerTransportListener;
import org.apache.dubbo.remoting.http12.h1.Http1ServerUnaryChannelObserver;
import org.apache.dubbo.remoting.http12.message.DefaultListeningDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.ListeningDecoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.codec.JsonCodec;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.executor.ExecutorSupport;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.RpcInvocationBuildContext;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.AbstractServerTransportListener;
import org.apache.dubbo.rpc.protocol.tri.h12.DefaultHttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.UnaryServerCallListener;

public class DefaultHttp11ServerTransportListener
extends AbstractServerTransportListener<RequestMetadata, HttpInputMessage>
implements Http1ServerTransportListener {
    private final ExecutorSupport executorSupport;
    private final HttpChannel httpChannel;
    private Http1ServerChannelObserver serverChannelObserver;

    public DefaultHttp11ServerTransportListener(HttpChannel httpChannel, URL url, FrameworkModel frameworkModel) {
        super(frameworkModel, url, httpChannel);
        this.executorSupport = ExecutorRepository.getInstance((ApplicationModel)url.getOrDefaultApplicationModel()).getExecutorSupport(url);
        this.httpChannel = httpChannel;
        this.serverChannelObserver = new Http1ServerUnaryChannelObserver(httpChannel);
        this.serverChannelObserver.setResponseEncoder((HttpMessageEncoder)JsonCodec.INSTANCE);
        this.serverChannelObserver.setExceptionHandler(this.getExceptionHandler());
    }

    @Override
    protected Executor initializeExecutor(RequestMetadata metadata) {
        return new SerializingExecutor(this.executorSupport.getExecutor((Object)metadata));
    }

    @Override
    protected HttpMessageListener buildHttpMessageListener() {
        RpcInvocationBuildContext context = this.getContext();
        RpcInvocation rpcInvocation = this.buildRpcInvocation(context);
        ServerCallListener serverCallListener = this.startListener(rpcInvocation, context.getMethodDescriptor(), context.getInvoker());
        DefaultListeningDecoder listeningDecoder = new DefaultListeningDecoder(context.getHttpMessageDecoder(), context.getMethodMetadata().getActualRequestTypes());
        listeningDecoder.setListener(serverCallListener::onMessage);
        return new DefaultHttpMessageListener((ListeningDecoder)listeningDecoder);
    }

    private ServerCallListener startListener(RpcInvocation invocation, MethodDescriptor methodDescriptor, Invoker<?> invoker) {
        switch (methodDescriptor.getRpcType()) {
            case UNARY: {
                return new AutoCompleteUnaryServerCallListener(invocation, invoker, (StreamObserver<Object>)this.serverChannelObserver);
            }
            case SERVER_STREAM: {
                this.serverChannelObserver = new Http1ServerStreamChannelObserver(this.httpChannel);
                this.serverChannelObserver.setHeadersCustomizer(headers -> headers.set(HttpHeaderNames.CONTENT_TYPE.getName(), MediaType.TEXT_EVENT_STREAM.getName()));
                return new AutoCompleteServerStreamServerCallListener(invocation, invoker, (StreamObserver<Object>)this.serverChannelObserver);
            }
        }
        throw new UnsupportedOperationException("HTTP1.x only support unary and server-stream");
    }

    @Override
    protected void onMetadataCompletion(RequestMetadata metadata) {
        this.serverChannelObserver.setResponseEncoder(this.getContext().getHttpMessageEncoder());
        super.onMetadataCompletion(metadata);
    }

    @Override
    protected void onError(Throwable throwable) {
        this.serverChannelObserver.onError(throwable);
    }

    @Override
    protected void initializeAltSvc(URL url) {
        String protocolId = TripleProtocol.isHttp3Enabled(url) ? "h3" : "h2";
        int bindPort = url.getParameter("bind.port", url.getPort());
        this.serverChannelObserver.setAltSvc(protocolId + "=\":" + bindPort + "\"");
    }

    public void close() throws Exception {
        this.serverChannelObserver.close();
    }

    private static class AutoCompleteUnaryServerCallListener
    extends UnaryServerCallListener {
        public AutoCompleteUnaryServerCallListener(RpcInvocation invocation, Invoker<?> invoker, StreamObserver<Object> responseObserver) {
            super(invocation, invoker, responseObserver, false);
        }

        @Override
        public void onMessage(Object message) {
            super.onMessage(message);
            this.onComplete();
        }
    }

    private static class AutoCompleteServerStreamServerCallListener
    extends ServerStreamServerCallListener {
        public AutoCompleteServerStreamServerCallListener(RpcInvocation invocation, Invoker<?> invoker, StreamObserver<Object> responseObserver) {
            super(invocation, invoker, responseObserver);
        }

        @Override
        public void onMessage(Object message) {
            super.onMessage(message);
            this.onComplete();
        }
    }
}

