/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.ErrorResponse;
import org.apache.dubbo.remoting.http12.ExceptionHandler;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.exception.HttpResultPayloadException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public final class CompositeExceptionHandler
implements ExceptionHandler<Throwable, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeExceptionHandler.class);
    private final List<ExceptionHandler> exceptionHandlers;
    private final Map<Class, List<ExceptionHandler>> cache = CollectionUtils.newConcurrentHashMap();

    public CompositeExceptionHandler(FrameworkModel frameworkModel) {
        this.exceptionHandlers = frameworkModel.getActivateExtensions(ExceptionHandler.class);
    }

    public Level resolveLogLevel(Throwable error) {
        if (error instanceof HttpResultPayloadException) {
            return Level.DEBUG;
        }
        List<ExceptionHandler> exceptionHandlers = this.getSuitableExceptionHandlers(error.getClass());
        int len = exceptionHandlers.size();
        for (int i = 0; i < len; ++i) {
            Level level = exceptionHandlers.get(i).resolveLogLevel(error);
            if (level == null) continue;
            return level;
        }
        if (error instanceof HttpStatusException) {
            int httpStatusCode = ((HttpStatusException)error).getStatusCode();
            if (httpStatusCode < HttpStatus.BAD_REQUEST.getCode()) {
                return Level.DEBUG;
            }
            if (httpStatusCode < HttpStatus.INTERNAL_SERVER_ERROR.getCode()) {
                return Level.INFO;
            }
        }
        return Level.ERROR;
    }

    public HttpResult handle(Throwable error) {
        if ((error = ExceptionUtils.unwrap(error)) instanceof HttpResultPayloadException) {
            return ((HttpResultPayloadException)error).getResult();
        }
        List<ExceptionHandler> exceptionHandlers = this.getSuitableExceptionHandlers(error.getClass());
        int len = exceptionHandlers.size();
        for (int i = 0; i < len; ++i) {
            HttpResult result = exceptionHandlers.get(i).handle(error);
            if (result == null) continue;
            return result;
        }
        int statusCode = error instanceof HttpStatusException ? ((HttpStatusException)error).getStatusCode() : TriRpcStatus.grpcCodeToHttpStatus(TriRpcStatus.getStatus((Throwable)error).code);
        if (TripleProtocol.VERBOSE_ENABLED) {
            if (statusCode < 1) {
                statusCode = HttpStatus.INTERNAL_SERVER_ERROR.getCode();
            }
            LOGGER.info("Http request process error response: status={}", new Object[]{statusCode, error});
            ErrorResponse response = new ErrorResponse();
            response.setStatus(String.valueOf(statusCode));
            response.setMessage(ExceptionUtils.buildVerboseMessage(error));
            return HttpResult.of((int)statusCode, (Object)response);
        }
        return statusCode > 0 ? HttpResult.of((int)statusCode, (Object)error) : null;
    }

    private List<ExceptionHandler> getSuitableExceptionHandlers(Class type) {
        return this.cache.computeIfAbsent(type, k -> {
            ArrayList result = new ArrayList();
            for (ExceptionHandler handler : this.exceptionHandlers) {
                Class<?> supportType = TypeUtils.getSuperGenericType(handler.getClass(), 0);
                if (supportType == null || !supportType.isAssignableFrom(type)) continue;
                result.add(handler);
            }
            return result.isEmpty() ? Collections.emptyList() : result;
        });
    }
}

