/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http2;

import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.serial.SerializingExecutor;
import org.apache.dubbo.remoting.http12.FlowControlStreamObserver;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.h2.CancelStreamException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2ServerChannelObserver;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.remoting.http12.message.DefaultListeningDecoder;
import org.apache.dubbo.remoting.http12.message.DefaultStreamingDecoder;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.ListeningDecoder;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.remoting.http12.message.codec.JsonCodec;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.executor.ExecutorSupport;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.RpcInvocationBuildContext;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.AbstractServerTransportListener;
import org.apache.dubbo.rpc.protocol.tri.h12.BiStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.StreamingHttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.UnaryServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.Http2ServerCallToObserverAdapter;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.Http2ServerUnaryChannelObserver;

public class GenericHttp2ServerTransportListener
extends AbstractServerTransportListener<Http2Header, Http2InputMessage>
implements Http2TransportListener {
    private final ExecutorSupport executorSupport;
    private final StreamingDecoder streamingDecoder;
    private final FrameworkModel frameworkModel;
    private final H2StreamChannel h2StreamChannel;
    private Http2ServerChannelObserver serverChannelObserver;
    private ServerCallListener serverCallListener;

    public GenericHttp2ServerTransportListener(H2StreamChannel h2StreamChannel, URL url, FrameworkModel frameworkModel) {
        super(frameworkModel, url, (HttpChannel)h2StreamChannel);
        this.executorSupport = ExecutorRepository.getInstance((ApplicationModel)url.getOrDefaultApplicationModel()).getExecutorSupport(url);
        this.streamingDecoder = this.newStreamingDecoder();
        this.serverChannelObserver = this.newHttp2ServerChannelObserver(frameworkModel, h2StreamChannel);
        this.serverChannelObserver.setResponseEncoder((HttpMessageEncoder)JsonCodec.INSTANCE);
        this.serverChannelObserver.setStreamingDecoder(this.streamingDecoder);
        this.serverChannelObserver.setExceptionHandler(this.getExceptionHandler());
        this.frameworkModel = frameworkModel;
        this.h2StreamChannel = h2StreamChannel;
    }

    protected StreamingDecoder newStreamingDecoder() {
        return new DefaultStreamingDecoder();
    }

    protected Http2ServerChannelObserver newHttp2ServerChannelObserver(FrameworkModel frameworkModel, H2StreamChannel h2StreamChannel) {
        return new Http2ServerCallToObserverAdapter(frameworkModel, h2StreamChannel);
    }

    @Override
    protected Executor initializeExecutor(Http2Header metadata) {
        return new SerializingExecutor(this.executorSupport.getExecutor((Object)metadata));
    }

    @Override
    protected HttpMessageListener buildHttpMessageListener() {
        RpcInvocationBuildContext context = this.getContext();
        RpcInvocation rpcInvocation = this.buildRpcInvocation(context);
        this.serverCallListener = this.startListener(rpcInvocation, context.getMethodDescriptor(), context.getInvoker());
        DefaultListeningDecoder listeningDecoder = new DefaultListeningDecoder(context.getHttpMessageDecoder(), context.getMethodMetadata().getActualRequestTypes());
        listeningDecoder.setListener((ListeningDecoder.Listener)new Http2StreamingDecodeListener(this.serverCallListener));
        this.streamingDecoder.setFragmentListener((StreamingDecoder.FragmentListener)new StreamingDecoder.DefaultFragmentListener((ListeningDecoder)listeningDecoder));
        this.getServerChannelObserver().setStreamingDecoder(this.streamingDecoder);
        return new StreamingHttpMessageListener(this.streamingDecoder);
    }

    private ServerCallListener startListener(RpcInvocation invocation, MethodDescriptor methodDescriptor, Invoker<?> invoker) {
        switch (methodDescriptor.getRpcType()) {
            case UNARY: {
                this.onUnary();
                this.onListenerStart();
                return this.startUnary(invocation, invoker, this.getServerChannelObserver());
            }
            case SERVER_STREAM: {
                this.onListenerStart();
                return this.startServerStreaming(invocation, invoker, this.getServerChannelObserver());
            }
            case BI_STREAM: 
            case CLIENT_STREAM: {
                this.onListenerStart();
                return this.startBiStreaming(invocation, invoker, this.getServerChannelObserver());
            }
        }
        throw new IllegalStateException("Can not reach here");
    }

    protected void onUnary() {
        this.serverChannelObserver = new Http2ServerUnaryChannelObserver(this.frameworkModel, this.h2StreamChannel);
        this.serverChannelObserver.setResponseEncoder((HttpMessageEncoder)JsonCodec.INSTANCE);
        this.serverChannelObserver.setStreamingDecoder(this.streamingDecoder);
    }

    protected void onListenerStart() {
        CancellationContext cancellationContext = RpcContext.getCancellationContext();
        this.serverChannelObserver.setCancellationContext(cancellationContext);
    }

    private UnaryServerCallListener startUnary(RpcInvocation invocation, Invoker<?> invoker, Http2ServerChannelObserver responseObserver) {
        return new UnaryServerCallListener(invocation, invoker, (StreamObserver<Object>)responseObserver, this.applyCustomizeException());
    }

    private ServerStreamServerCallListener startServerStreaming(RpcInvocation invocation, Invoker<?> invoker, Http2ServerChannelObserver responseObserver) {
        return new ServerStreamServerCallListener(invocation, invoker, (StreamObserver<Object>)responseObserver);
    }

    private BiStreamServerCallListener startBiStreaming(RpcInvocation invocation, Invoker<?> invoker, Http2ServerChannelObserver responseObserver) {
        return new BiStreamServerCallListener(invocation, invoker, (FlowControlStreamObserver<Object>)responseObserver);
    }

    @Override
    protected void initializeAltSvc(URL url) {
        if (TripleProtocol.isHttp3Enabled(url)) {
            int bindPort = url.getParameter("bind.port", url.getPort());
            this.serverChannelObserver.setAltSvc("h3=\":" + bindPort + "\"");
        }
    }

    @Override
    protected void onMetadataCompletion(Http2Header metadata) {
        this.serverChannelObserver.setResponseEncoder(this.getContext().getHttpMessageEncoder());
        this.serverChannelObserver.request(1);
        if (metadata.isEndStream()) {
            this.getStreamingDecoder().close();
        }
    }

    @Override
    protected void onDataCompletion(Http2InputMessage message) {
        if (message.isEndStream()) {
            this.getStreamingDecoder().close();
        }
    }

    @Override
    protected void onError(Throwable throwable) {
        this.serverChannelObserver.onError(throwable);
    }

    @Override
    protected void onError(Http2InputMessage message, Throwable throwable) {
        try {
            message.close();
        }
        catch (Exception e) {
            throwable.addSuppressed(e);
        }
        this.onError(throwable);
    }

    @Override
    protected void onFinally(Http2InputMessage message) {
    }

    public void cancelByRemote(long errorCode) {
        this.serverChannelObserver.cancel((Throwable)CancelStreamException.fromRemote((long)errorCode));
        if (this.serverCallListener != null) {
            this.serverCallListener.onCancel(errorCode);
        }
    }

    protected StreamingDecoder getStreamingDecoder() {
        return this.streamingDecoder;
    }

    protected final Http2ServerChannelObserver getServerChannelObserver() {
        return this.serverChannelObserver;
    }

    protected boolean applyCustomizeException() {
        return false;
    }

    public void close() throws Exception {
        this.getServerChannelObserver().close();
    }

    private static class Http2StreamingDecodeListener
    implements ListeningDecoder.Listener {
        private final ServerCallListener serverCallListener;

        private Http2StreamingDecodeListener(ServerCallListener serverCallListener) {
            this.serverCallListener = serverCallListener;
        }

        public void onMessage(Object message) {
            this.serverCallListener.onMessage(message);
        }

        public void onClose() {
            this.serverCallListener.onComplete();
        }
    }
}

