/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.filter;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilter;

final class DefaultFilterChain
implements RestFilter.FilterChain,
RestFilter.Listener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(DefaultFilterChain.class);
    private final RestFilter[] filters;
    private final Invocation invocation;
    private final Supplier<Result> action;
    private int cursor;
    private Result result;
    private CompletableFuture<AppResponse> resultFuture;

    DefaultFilterChain(RestFilter[] filters, Invocation invocation, Supplier<Result> action) {
        this.filters = filters;
        this.invocation = invocation;
        this.action = action;
    }

    public Result execute(HttpRequest request, HttpResponse response) throws Exception {
        this.doFilter(request, response);
        return this.result;
    }

    @Override
    public void doFilter(HttpRequest request, HttpResponse response) throws Exception {
        if (this.cursor < this.filters.length) {
            this.filters[this.cursor++].doFilter(request, response, this);
            return;
        }
        if (this.resultFuture == null) {
            this.result = this.action.get();
        } else {
            this.action.get().whenCompleteWithContext((r, e) -> {
                if (e == null) {
                    this.resultFuture.complete(new AppResponse(r));
                } else {
                    this.resultFuture.complete(new AppResponse(e));
                }
            });
        }
    }

    @Override
    public CompletableFuture<Boolean> doFilterAsync(HttpRequest request, HttpResponse response) {
        if (this.resultFuture == null) {
            this.resultFuture = new CompletableFuture();
            this.result = new AsyncRpcResult(this.resultFuture, this.invocation);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        future.whenComplete((v, t) -> {
            if (t == null) {
                if (v != null && v.booleanValue()) {
                    try {
                        this.doFilter(request, response);
                    }
                    catch (Exception e) {
                        this.resultFuture.complete(new AppResponse((Throwable)e));
                    }
                } else {
                    this.resultFuture.complete(new AppResponse());
                }
            } else {
                this.resultFuture.complete(new AppResponse(t));
            }
        });
        return future;
    }

    @Override
    public void onResponse(Result result, HttpRequest request, HttpResponse response) {
        for (int i = this.cursor - 1; i > -1; --i) {
            RestFilter filter = this.filters[i];
            if (!(filter instanceof RestFilter.Listener)) continue;
            try {
                ((RestFilter.Listener)((Object)filter)).onResponse(result, request, response);
                continue;
            }
            catch (Throwable t) {
                LOGGER.error("0-12", "", "", "Call onResponse for filter [" + filter + "] error");
            }
        }
    }

    @Override
    public void onError(Throwable t, HttpRequest request, HttpResponse response) {
        for (int i = this.cursor - 1; i > -1; --i) {
            RestFilter filter = this.filters[i];
            if (!(filter instanceof RestFilter.Listener)) continue;
            try {
                ((RestFilter.Listener)((Object)filter)).onError(t, request, response);
                continue;
            }
            catch (Throwable th) {
                LOGGER.error("0-12", "", "", "Call onError for filter [" + filter + "] error");
            }
        }
    }
}

