/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.beans.support.InstantiationStrategy;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionAccessorAware;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestInitializeException;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.DefaultFilterChain;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtension;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtensionAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilterAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RadixTree;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

@Activate(group={"provider"}, order=1000)
public class RestExtensionExecutionFilter
extends RestFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestExtensionExecutionFilter.class);
    private static final String KEY = RestExtensionExecutionFilter.class.getSimpleName();
    private final Map<RestFilter, RadixTree<Boolean>> filterTreeCache = CollectionUtils.newConcurrentHashMap();
    private final ApplicationModel applicationModel;
    private final List<RestExtensionAdapter<Object>> extensionAdapters;

    public RestExtensionExecutionFilter(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.extensionAdapters = applicationModel.getActivateExtensions(RestExtensionAdapter.class);
    }

    @Override
    protected Result invoke(Invoker<?> invoker, Invocation invocation, HttpRequest request, HttpResponse response) throws RpcException {
        RestFilter[] filters = this.matchFilters(this.getFilters(invoker), request.path());
        DefaultFilterChain chain = new DefaultFilterChain(filters, invocation, () -> invoker.invoke(invocation));
        invocation.put((Object)KEY, (Object)chain);
        try {
            Result result = chain.execute(request, response);
            if (result != null) {
                return result;
            }
            Object body = response.body();
            if (body instanceof Throwable) {
                response.setBody(null);
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)((Throwable)body), (Invocation)invocation);
            }
            if (body instanceof CompletableFuture) {
                CompletableFuture future = (CompletableFuture)body;
                response.setBody(null);
                return new AsyncRpcResult((CompletableFuture)future.handleAsync((v, t) -> {
                    AppResponse r = new AppResponse(invocation);
                    if (t != null) {
                        r.setException(t);
                    } else {
                        r.setValue(v);
                    }
                    return r;
                }), invocation);
            }
            return AsyncRpcResult.newDefaultAsyncResult((Invocation)invocation);
        }
        catch (Throwable t2) {
            throw ExceptionUtils.wrap(t2);
        }
    }

    @Override
    protected void onResponse(Result result, Invoker<?> invoker, Invocation invocation, HttpRequest request, HttpResponse response) {
        Object body;
        DefaultFilterChain chain = (DefaultFilterChain)invocation.get((Object)KEY);
        if (chain == null) {
            return;
        }
        chain.onResponse(result, request, response);
        if (result.hasException() && (body = response.body()) != null) {
            if (body instanceof Throwable) {
                result.setException((Throwable)body);
            } else {
                result.setValue(body);
                result.setException(null);
            }
            response.setBody(null);
        }
    }

    @Override
    protected void onError(Throwable t, Invoker<?> invoker, Invocation invocation, HttpRequest request, HttpResponse response) {
        DefaultFilterChain chain = (DefaultFilterChain)invocation.get((Object)KEY);
        if (chain == null) {
            return;
        }
        chain.onError(t, request, response);
    }

    private RestFilter[] matchFilters(RestFilter[] filters, String path) {
        int len = filters.length;
        BitSet bitSet = new BitSet(len);
        block0: for (int i = 0; i < len; ++i) {
            RestFilter filter = filters[i];
            Object[] patterns = filter.getPatterns();
            if (ArrayUtils.isEmpty((Object[])patterns)) continue;
            RadixTree filterTree = this.filterTreeCache.computeIfAbsent(filter, arg_0 -> RestExtensionExecutionFilter.lambda$matchFilters$2((String[])patterns, arg_0));
            List matches = filterTree.match(path);
            int size = matches.size();
            if (size == 0) {
                bitSet.set(i);
                continue;
            }
            for (int j = 0; j < size; ++j) {
                if (((Boolean)matches.get(j).getValue()).booleanValue()) continue;
                bitSet.set(i);
                continue block0;
            }
        }
        if (bitSet.isEmpty()) {
            return filters;
        }
        Object[] matched = new RestFilter[len - bitSet.cardinality()];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            if (bitSet.get(i)) continue;
            matched[j++] = filters[i];
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Matched filters for path '{}' is {}", new Object[]{path, Arrays.toString(matched)});
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestFilter[] getFilters(Invoker<?> invoker) {
        URL url = invoker.getUrl();
        RestFilter[] filters = this.getFilters(url);
        if (filters != null) {
            return filters;
        }
        Invoker<?> invoker2 = invoker;
        synchronized (invoker2) {
            filters = this.getFilters(url);
            if (filters != null) {
                return filters;
            }
            filters = this.loadFilters(url);
            url.putAttribute("restExtensionsAttributeKey", (Object)filters);
            return filters;
        }
    }

    private RestFilter[] getFilters(URL url) {
        return (RestFilter[])url.getAttribute("restExtensionsAttributeKey");
    }

    private RestFilter[] loadFilters(URL url) {
        LOGGER.info("Loading rest filters for {}", new Object[]{url});
        ArrayList<RestFilter> extensions = new ArrayList<RestFilter>();
        String extensionConfig = url.getParameter("extension");
        InstantiationStrategy strategy = new InstantiationStrategy(() -> this.applicationModel);
        for (String className : StringUtils.tokenize((String)extensionConfig, (char[])new char[0])) {
            try {
                Object extension = strategy.instantiate(TypeUtils.loadClass(className));
                if (extension instanceof ExtensionAccessorAware) {
                    ((ExtensionAccessorAware)extension).setExtensionAccessor((ExtensionAccessor)this.applicationModel);
                }
                this.adaptExtension(extension, extensions);
            }
            catch (Throwable t) {
                throw new RestInitializeException(t, Messages.EXTENSION_INIT_FAILED, className, url);
            }
        }
        List restExtensions = this.applicationModel.getExtensionLoader(RestExtension.class).getActivateExtension(url, "rest.filter");
        for (RestExtension extension : restExtensions) {
            this.adaptExtension(extension, extensions);
        }
        extensions.sort(Comparator.comparingInt(RestUtils::getPriority));
        return extensions.toArray(new RestFilter[0]);
    }

    private void adaptExtension(Object extension, List<RestFilter> extensions) {
        if (extension instanceof Supplier) {
            extension = ((Supplier)extension).get();
        }
        if (extension instanceof RestFilter) {
            this.addRestFilter(extension, (RestFilter)extension, extensions);
            return;
        }
        for (RestExtensionAdapter<Object> adapter : this.extensionAdapters) {
            if (!adapter.accept(extension)) continue;
            this.addRestFilter(extension, adapter.adapt(extension), extensions);
        }
    }

    private void addRestFilter(Object extension, RestFilter filter, List<RestFilter> extensions) {
        extensions.add(filter);
        if (!LOGGER.isInfoEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("Rest filter [").append(extension).append("] loaded");
        if (filter.getPriority() != 0) {
            sb.append(", priority=").append(filter.getPriority());
        }
        if (ArrayUtils.isNotEmpty((Object[])filter.getPatterns())) {
            sb.append(", patterns=").append(Arrays.toString(filter.getPatterns()));
        }
        LOGGER.info(sb.toString());
    }

    private static /* synthetic */ RadixTree lambda$matchFilters$2(String[] patterns, RestFilter f) {
        RadixTree<Boolean> tree = new RadixTree<Boolean>();
        for (String pattern : patterns) {
            if (!StringUtils.isNotEmpty((String)pattern)) continue;
            if (pattern.charAt(0) == '!') {
                tree.addPath(pattern.substring(1), Boolean.valueOf(false));
                continue;
            }
            tree.addPath(pattern, Boolean.valueOf(true));
        }
        return tree;
    }
}

