/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.basic;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.RestParameterException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AbstractAnnotationBaseArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.basic.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

@Activate
public class ParamArgumentResolver
extends AbstractAnnotationBaseArgumentResolver {
    @Override
    protected NamedValueMeta createNamedValueMeta(ParameterMeta param, AnnotationMeta<Annotation> ann) {
        String defaultValue = ann.getString("defaultValue");
        if ("\n\t\t\n\t\t\n_DEFAULT_NONE_\n\t\t\t\t\n".equals(defaultValue)) {
            defaultValue = null;
        }
        ParamType paramType = (ParamType)ann.getEnum("type");
        return new ParamNamedValueMeta(ann.getValue(), ann.getBoolean("required"), defaultValue, paramType);
    }

    @Override
    public Class<Annotation> accept() {
        return Annotations.Param.type();
    }

    @Override
    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        switch (((ParamNamedValueMeta)meta).paramType) {
            case PathVariable: {
                return ParamArgumentResolver.resolvePathVariable(meta, request);
            }
            case MatrixVariable: {
                return CollectionUtils.first(ParamArgumentResolver.resolveMatrixVariable(meta, request));
            }
            case Param: {
                return request.parameter(meta.name());
            }
            case Header: {
                return request.header(meta.name());
            }
            case Cookie: {
                return request.cookie(meta.name());
            }
            case Attribute: {
                return request.attribute(meta.name());
            }
            case Part: {
                return request.part(meta.name());
            }
            case Body: {
                if (RequestUtils.isFormOrMultiPart(request)) {
                    return request.formParameter(meta.name());
                }
                return RequestUtils.decodeBody(request, meta.genericType());
            }
        }
        return null;
    }

    @Override
    protected Object filterValue(Object value, NamedValueMeta meta) {
        return "".equals(value) ? meta.defaultValue() : value;
    }

    @Override
    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        switch (((ParamNamedValueMeta)meta).paramType) {
            case PathVariable: {
                String value = ParamArgumentResolver.resolvePathVariable(meta, request);
                return value == null ? Collections.emptyList() : Collections.singletonList(value);
            }
            case MatrixVariable: {
                return ParamArgumentResolver.resolveMatrixVariable(meta, request);
            }
            case Param: {
                return request.parameterValues(meta.name());
            }
            case Header: {
                return request.headerValues(meta.name());
            }
            case Cookie: {
                Collection cookies = request.cookies();
                if (cookies.isEmpty()) {
                    return Collections.emptyList();
                }
                String name = meta.name();
                ArrayList<HttpCookie> result = new ArrayList<HttpCookie>(cookies.size());
                for (HttpCookie cookie : cookies) {
                    if (!name.equals(cookie.name())) continue;
                    result.add(cookie);
                }
                return result;
            }
            case Attribute: {
                return request.attribute(meta.name());
            }
            case Part: {
                return meta.type() == byte[].class ? request.part(meta.name()) : request.parts();
            }
            case Body: {
                Class<?> type = meta.type();
                if (type == byte[].class) {
                    try {
                        return StreamUtils.readBytes((InputStream)request.inputStream());
                    }
                    catch (IOException e) {
                        throw new RestException(e);
                    }
                }
                if (RequestUtils.isFormOrMultiPart(request)) {
                    return request.formParameterValues(meta.name());
                }
                return RequestUtils.decodeBody(request, meta.genericType());
            }
        }
        return null;
    }

    @Override
    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        switch (((ParamNamedValueMeta)meta).paramType) {
            case PathVariable: {
                String value = ParamArgumentResolver.resolvePathVariable(meta, request);
                return value == null ? Collections.emptyMap() : Collections.singletonMap(meta.name(), value);
            }
            case MatrixVariable: {
                return CollectionUtils.first(ParamArgumentResolver.resolveMatrixVariable(meta, request));
            }
            case Param: {
                return RequestUtils.getParametersMap(request);
            }
            case Header: {
                return request.headers();
            }
            case Cookie: {
                Collection cookies = request.cookies();
                if (cookies.isEmpty()) {
                    return Collections.emptyMap();
                }
                Map mapValue = CollectionUtils.newLinkedHashMap((int)cookies.size());
                for (HttpCookie cookie : cookies) {
                    mapValue.computeIfAbsent(cookie.name(), k -> new ArrayList()).add(cookie);
                }
                return mapValue;
            }
            case Attribute: {
                return request.attributes();
            }
            case Part: {
                Collection parts = request.parts();
                if (parts.isEmpty()) {
                    return Collections.emptyMap();
                }
                LinkedHashMap<String, HttpRequest.FileUpload> result = new LinkedHashMap<String, HttpRequest.FileUpload>(parts.size());
                for (HttpRequest.FileUpload part : parts) {
                    result.put(part.name(), part);
                }
                return result;
            }
            case Body: {
                if (RequestUtils.isFormOrMultiPart(request)) {
                    return RequestUtils.getFormParametersMap(request);
                }
                return RequestUtils.decodeBody(request, meta.genericType());
            }
        }
        return null;
    }

    private static String resolvePathVariable(NamedValueMeta meta, HttpRequest request) {
        Map variableMap = (Map)request.attribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables");
        if (variableMap == null) {
            if (meta.required()) {
                throw new RestParameterException(Messages.ARGUMENT_VALUE_MISSING, meta.name(), meta.type());
            }
            return null;
        }
        String value = (String)variableMap.get(meta.name());
        if (value == null) {
            return null;
        }
        int index = value.indexOf(59);
        return RequestUtils.decodeURL(index == -1 ? value : value.substring(0, index));
    }

    private static List<String> resolveMatrixVariable(NamedValueMeta meta, HttpRequest request) {
        Map variableMap = (Map)request.attribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables");
        return RequestUtils.parseMatrixVariableValues(variableMap, meta.name());
    }

    private static class ParamNamedValueMeta
    extends NamedValueMeta {
        private final ParamType paramType;

        ParamNamedValueMeta(String name, boolean required, String defaultValue, ParamType paramType) {
            super(name, required, defaultValue);
            this.paramType = paramType;
        }
    }
}

