/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.util;

public final class KeyString
implements CharSequence {
    private final String value;
    private final int offset;
    private final int length;
    private final boolean caseSensitive;

    public KeyString(String value, int start, int end, boolean caseSensitive) {
        this.value = value;
        this.offset = start;
        this.length = (end == -1 ? value.length() : end) - start;
        this.caseSensitive = caseSensitive;
    }

    public KeyString(String value, int start, int end) {
        this(value, start, end, true);
    }

    public KeyString(String value, int end, boolean caseSensitive) {
        this.value = value;
        this.offset = 0;
        this.length = end == -1 ? value.length() : end;
        this.caseSensitive = caseSensitive;
    }

    public KeyString(String value, int end) {
        this(value, end, true);
    }

    public KeyString(String value, boolean caseSensitive) {
        this.value = value;
        this.offset = 0;
        this.length = value.length();
        this.caseSensitive = caseSensitive;
    }

    public KeyString(String value) {
        this(value, false);
    }

    public KeyString(KeyString path, int start, int end) {
        this(path.value, path.offset + start, path.offset + end, path.caseSensitive);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(this.offset + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.substring(this.offset + start, this.offset + end);
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.length; ++i) {
            h = 31 * h + (this.caseSensitive ? this.value.charAt(this.offset + i) : Character.toLowerCase(this.value.charAt(this.offset + i)));
        }
        return h;
    }

    public boolean equals(Object obj) {
        KeyString other = (KeyString)obj;
        return this.value.regionMatches(!this.caseSensitive, this.offset, other.value, other.offset, this.length);
    }

    @Override
    public String toString() {
        return this.value.substring(this.offset, this.offset + this.length);
    }

    public int indexOf(char ch, int start) {
        int index = this.value.indexOf(ch, this.offset + start);
        return index == -1 || index >= this.offset + this.length ? -1 : index - this.offset;
    }

    public boolean regionMatches(int start, String value, int i, int length) {
        return this.value.regionMatches(!this.caseSensitive, this.offset + start, value, i, length);
    }

    public String substring(int start) {
        return this.value.substring(this.offset + start, this.offset + this.length);
    }

    public String substring(int start, int end) {
        return this.value.substring(this.offset + start, this.offset + (end == -1 ? this.length : end));
    }
}

